/* X-SPDX-Source-URL: https://git.kernel.org/pub/scm/linux/kernel/git/stable/linux.git */
/* X-SPDX-Source-Tag: v5.11.11 */
/* X-SPDX-Source-File: include/linux/mod_devicetable.h */
/* SPDX-License-Identifier: GPL-2.0-only */
/* X-SPDX-Comment: This file takes the definition of auxiliary_device_id from
 *                 the original file to provide this definition to allow
 *                 building auxiliary bus as an out of tree module on kernels
 *                 without this included. */

/*
 * Device tables which are exported to userspace via
 * scripts/mod/file2alias.c.  You must keep that file in sync with this
 * header.
 */

#ifndef LINUX_MOD_DEVICETABLE_AUXILIARY_H
#define LINUX_MOD_DEVICETABLE_AUXILIARY_H

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/uuid.h>
typedef unsigned long kernel_ulong_t;
#endif


#define AUXILIARY_NAME_SIZE 32
#define AUXILIARY_MODULE_PREFIX "auxiliary:"

struct auxiliary_device_id {
	char name[AUXILIARY_NAME_SIZE];
	kernel_ulong_t driver_data;
};

#endif /* LINUX_MOD_DEVICETABLE_AUXILIARY_H */
