﻿NDSummary.OnToolTipsLoaded("svClass:axi4stream_mst_driver",{311:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI4STREAM Master Driver Object. The driver receives transactions from the user environment and drives stream interface. It returns a completed transaction when the transaction is accepted when the transaction\'s driver_return_item_policy is set to XIL_AXI4STREAM_AT_ACCEPT_RETURN.</div></div>",313:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">axi4stream_vif_proxy `XIL_AXI4STREAM_PARAM_ORDER&nbsp; vif_proxy; AXI4STREAM VIF Proxy Class.</div></div>",315:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype315\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi4stream_mst_driver&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new axi4stream master driver</div></div>",316:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype316\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi4stream_vif_proxy `</td><td class=\"PType\">XIL_AXI4STREAM_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Assigns the virtual interface of the driver.</div></div>",317:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype317\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_forward_progress_timeout_value(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">value</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of cycles that the driver will wait until it will flag a watch dog error.&nbsp; Setting this to a very large value will cause a hung simulation to continue for a longer time.&nbsp; Setting this to a very small number may not allow the slave to respond.</div></div>",318:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype318\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi4stream_uint get_forward_progress_timeout_value();</div></div><div class=\"TTSummary\">Returns the current value of the forward_progress_timeout_value.</div></div>",319:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype319\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi4stream_boolean_t is_driver_idle();</div></div><div class=\"TTSummary\">When the driver is actively processing a transaction this function will return FALSE.</div></div>",320:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype320\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task run_phase();</div></div><div class=\"TTSummary\">Start control processes for operation</div></div>",321:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype321\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_phase();</div></div><div class=\"TTSummary\">Stops all control processes.</div></div>",322:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype322\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi4stream_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Send axi4stream transaction object to the driver</div></div>",323:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype323\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi4stream_transaction create_transaction (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_transaction&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns an axi4stream transaction that has been &quot;newed&quot;</div></div>"});