﻿NDSummary.OnToolTipsLoaded("svClass:axi4stream_passthrough_agent",{358:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI4STREAM Passthrough Agent. The AXI4STREAM passthrough agent is comprised of other classes which are monitor,runtime master driver,&nbsp; runtime slave driver. By default, passthrough agent is in monitor mode. In order to issue transaction as master, it has to be switched to runtime master mode, in order to receive transaction, it has to be switched into runtime slave mode. Please refer PG 277 section about &quot;Useful Coding Guidelines and Examples&quot; for more details.</div></div>",360:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">axi4stream_mst_driver `XIL_AXI4STREAM_PARAM_ORDER mst_driver;</div></div>",362:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype362\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span> (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi4stream_passthrough_agent&quot;</span>,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">virtual interface</span> axi4stream_vip_if `</td><td class=\"PType\">XIL_AXI4STREAM_PARAM_ORDER&nbsp;</td><td class=\"PName\">vif</td><td></td><td class=\"last\"></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create an AXI4STREAM Passthrough Agent. ~name~ is the instance name and axi4stream_vip_if is the interface in the design.&nbsp; Please see PG277 for how to find the interface in design hierarchy.</div></div>",363:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype363\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_verbosity(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_verbosity&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the verbosity of the Agent and all sub classes. If updated is bigger than 300, it will print out necessary log message. Refer xil_info for verbosity information.</div></div>",364:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype364\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi4stream_vif_proxy `</td><td class=\"PType\">XIL_AXI4STREAM_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the Agent\'s virtual interface. This is the interface that will be monitored and/or driven.</div></div>",365:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype365\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_agent_tag(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the tag of the Agent and all sub classes. If more than one VIPs(in master mode) being used in the same testbench, User can use set_agent_tag with different tag to tell where exactly the log message comes from.</div></div>",366:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype366\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task start_monitor();</div></div><div class=\"TTSummary\">Enables the monitor in this agent to start collecting data.</div></div>",367:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype367\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task start_slave();</div></div><div class=\"TTSummary\">Enables the monitor and slave driver in this agent to start collecting data.&nbsp; The slave driver will only issue ready generation when the send functions are called.</div></div>",368:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype368\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task start_master();</div></div><div class=\"TTSummary\">Enables the monitor and master driver in this agent to start collecting data.&nbsp; The master driver will only issue transactions when the send functions are called.</div></div>",369:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype369\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_master();</div></div><div class=\"TTSummary\">Disables the driver of the master. Once disabled, no further action will occur by the drivers.</div></div>",370:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype370\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_slave();</div></div><div class=\"TTSummary\">Disables the driver of the slave. Once disabled, no further action will occur by the drivers.</div></div>",371:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype371\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_monitor();</div></div><div class=\"TTSummary\">Disables the monitor in this agent from start collecting data. . Once disabled, no further action will occur by the monitor.</div></div>"});