﻿NDSummary.OnToolTipsLoaded("svClass:axi4stream_transaction",{168:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">The axi4stream_transaction class is the base class of AXI4STREAM Verification Component.It inherits all the methods of xil_sequence_item.In this transaction, it has cmd_id,dest,id,data,user,strb,keep,last, signal_set etc which can be accessed by set/get_x APIs.</div></div>",170:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype170\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi4stream_transaction&quot;</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi4stream_sigset_t&nbsp;</td><td class=\"PName\">set</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\">XIL_AXI4STREAM_SIGSET_READY | XIL_AXI4STREAM_SIGSET_DATA,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName\">dw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">32</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName\">uw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">32</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName\">bpb</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">8</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName\">idw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">2</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName\">destw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">4</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new axi4stream_transaction. ~name~ is the name of the instance.</div></div>",171:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype171\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> copy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">axi4stream_transaction&nbsp;</td><td class=\"PName last\">rhs</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Copies the contents of the input transaction to the current transaction</div></div>",172:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype172\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> axi4stream_transaction my_clone ();</div></div><div class=\"TTSummary\">Returns a clones of the contents of the transaction.</div></div>",173:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype173\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_id ();</div></div><div class=\"TTSummary\">Returns the value of TID of the transaction.</div></div>",174:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype174\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_id (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">new_id</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TID of the transaction.</div></div>",175:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype175\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi4stream_uint get_dest ();</div></div><div class=\"TTSummary\">Returns the value of TDEST of the transaction.</div></div>",176:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype176\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_dest (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">new_dest</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TDEST of the transaction.</div></div>",177:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype177\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> bit get_last ();</div></div><div class=\"TTSummary\">Returns the value of TLAST of the transaction. This transaction will return 1 when the TLAST signal is not enabled.</div></div>",178:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype178\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_last (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">bit&nbsp;</td><td class=\"PName last\">new_last</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TLAST of the transaction.</div></div>",179:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype179\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_strb(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span> xil_axi4stream_strb&nbsp;</td><td class=\"PType\">ext_strb&nbsp;</td><td class=\"PSymbols last\">[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the unpacked version of TSTRB of the transaction.</div></div>",180:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype180\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_strb (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input xil_axi4stream_strb&nbsp;</td><td class=\"PType\">updated&nbsp;</td><td class=\"PSymbols last\">[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TSTRB of the transaction using an unpacked array.</div></div>",181:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype181\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi4stream_strb_beat get_strb_beat();</div></div><div class=\"TTSummary\">Returns the beat type version of TSTRB of the transaction.</div></div>",182:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype182\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_strb_beat (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_strb_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TSTRB of the transaction using a beat type.</div></div>",183:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype183\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_keep(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span> xil_axi4stream_strb&nbsp;</td><td class=\"PType\">ext_keep&nbsp;</td><td class=\"PSymbols last\">[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the unpacked version of TKEEP of the transaction.</div></div>",184:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype184\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_keep (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input xil_axi4stream_strb&nbsp;</td><td class=\"PType\">updated&nbsp;</td><td class=\"PSymbols last\">[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TKEEP of the transaction using an unpacked array.</div></div>",185:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype185\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi4stream_strb_beat get_keep_beat();</div></div><div class=\"TTSummary\">Returns the beat type version of TKEEP of the transaction. It is different from get_keep since get_keep returns unpacked version of TKEEP.</div></div>",186:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype186\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_keep_beat (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_strb_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TKEEP of the transaction using a beat type. It is different from set_keep since set_keep using unpacked version of array.</div></div>",187:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype187\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> get_data(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span> xil_axi4stream_data_byte&nbsp;</td><td class=\"PType\">ext_data&nbsp;</td><td class=\"PSymbols last\">[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the unpacked version of TDATA of the transaction.</div></div>",188:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype188\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_data(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_data_byte&nbsp;</td><td class=\"PName last\">updated[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TDATA of the transaction using an unpacked array.</div></div>",189:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype189\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi4stream_data_beat get_data_beat();</div></div><div class=\"TTSummary\">Returns the beat type version of TDATA of the transaction.</div></div>",190:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype190\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_data_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_data_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TDATA of the transaction using a beat type.</div></div>",191:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype191\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_user_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_user_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of TUSER of the transaction using a beat type.</div></div>",192:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype192\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_user_beat get_user_beat();</div></div><div class=\"TTSummary\">Returns the beat type version of TUSER of the transaction.</div></div>",193:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype193\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_sigset_t get_signal_set();</div></div><div class=\"TTSummary\">Returns the current settings of the interface.</div></div>",194:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype194\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_signal_set(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_sigset_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of signal set. This value MUST match the interface properties.</div></div>",195:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype195\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_data_width();</div></div><div class=\"TTSummary\">Returns the DATA width of the transaction.</div></div>",196:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype196\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> resize_payload_arrays();</div></div><div class=\"TTSummary\">Creates/Adjusts the different internal data structures.</div></div>",197:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype197\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_data_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of DATA width for the transaction.</div></div>",198:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype198\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_dest_width();</div></div><div class=\"TTSummary\">Returns the DEST width of the transaction.</div></div>",199:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype199\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_dest_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of DEST width for the transaction.</div></div>",200:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype200\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_id_width();</div></div><div class=\"TTSummary\">Returns the ID width of the transaction.</div></div>",201:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype201\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_id_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of ID width for the transaction.</div></div>",202:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype202\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_user_width();</div></div><div class=\"TTSummary\">Returns the USER width of the transaction.</div></div>",203:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype203\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_user_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of USER width for the transaction.</div></div>",204:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype204\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_user_bits_per_byte(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the user bits per byte for the transaction.</div></div>",205:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype205\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_user_bits_per_byte();</div></div><div class=\"TTSummary\">Returns the value of the user bits per byte of the transaction.</div></div>",206:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype206\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_driver_return_item ();</div></div><div class=\"TTSummary\">Sets the driver_return_item property to XIL_AXI4STREAM_AT_ACCEPT_RETURN. driver_return_item can be XIL_AXI4STREAM_NO_RETURN,XIL_AXI4STREAM_AT_ASSERT_RETURN,XIL_AXI4STREAM_AT_ACCEPT_RETURN. please refer xil_axi4stream_driver_return_policy_t for more details.</div></div>",207:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype207\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_driver_return_item_policy (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_driver_return_policy_t&nbsp;</td><td class=\"PName last\">set</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the driver_return_item property of the transaction. Driver return item policy can be XIL_AXI4STREAM_NO_RETURN,XIL_AXI4STREAM_AT_ASSERT_RETURN, XIL_AXI4STREAM_AT_ACCEPT_RETURN. please refer xil_axi4stream_driver_return_policy_t for more details.</div></div>",208:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype208\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_driver_return_policy_t get_driver_return_item_policy ();</div></div><div class=\"TTSummary\">Returns the value of driver_return_item property of the transaction. Driver return item policy can be XIL_AXI4STREAM_NO_RETURN,XIL_AXI4STREAM_AT_ASSERT_RETURN, XIL_AXI4STREAM_AT_ACCEPT_RETURN. please refer xil_axi4stream_driver_return_policy_t for more details.</div></div>",209:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype209\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_driver_return_item ();</div></div><div class=\"TTSummary\">Set driver return item policy to be XIL_AXI4STREAM_NO_RETURN. Driver return item policy can be XIL_AXI4STREAM_NO_RETURN,XIL_AXI4STREAM_AT_ASSERT_RETURN,XIL_AXI4STREAM_AT_ACCEPT_RETURN. please refer xil_axi4stream_driver_return_policy_t for more details.</div></div>",210:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype210\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_cmd_id();</div></div><div class=\"TTSummary\">Returns cmd_id of the transaction</div></div>",211:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype211\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_xfer_alignment (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_xfer_alignment_t&nbsp;</td><td class=\"PName last\">set</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets xfer_alignment of the transaction. axi4stream transaction has four types of transfer alignment XIL_AXI4STREAM_XFER_ALL_SET, XIL_AXI4STREAM_XFER_ALL_NULLBYTE,XIL_AXI4STREAM_XFER_ALL_POSBYTE, XIL_AXI4STREAM_XFER_RANDOM. please refer xil_axi4stream_xfer_alignment_t for more details.</div></div>",212:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype212\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_xfer_alignment_t get_xfer_alignment ();</div></div><div class=\"TTSummary\">Returns xfer_alignment of the transaction. axi4stream transaction has four types of transfer alignment XIL_AXI4STREAM_XFER_ALL_SET, XIL_AXI4STREAM_XFER_ALL_NULLBYTE,XIL_AXI4STREAM_XFER_ALL_POSBYTE, XIL_AXI4STREAM_XFER_RANDOM. please refer xil_axi4stream_xfer_alignment_t for more details.</div></div>",213:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype213\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> convert2string();</div></div><div class=\"TTSummary\">Returns a form of string for axi4stream transaction which includes SIGNAL_SET, DEST, ID, USER, LAST,PAYLOAD(data, strb, keep) user bits.</div></div>",214:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype214\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> bit do_compare (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_object&nbsp;</td><td class=\"PName last\">rhs</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Compare current transaction with rhs, it includes comparison of signal_set and all the information of a transaction which are keep, strb, data, user, last, id, dest etc .</div></div>",215:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype215\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_uint get_delay();</div></div><div class=\"TTSummary\">Returns delay of the transaction This delay is from when the driver get the transaction item till it starts to drive data onto the data bus.</div></div>",216:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype216\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets delay of the transaction This delay is from when the driver get the transaction item till it starts to drive data onto the data bus.</div></div>",217:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype217\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_xfer_delay_insertion_policy_t get_delay_policy();</div></div><div class=\"TTSummary\">Returns delay_policy of the transaction</div></div>",218:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype218\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_delay_policy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_xfer_delay_insertion_policy_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This function is to set delay_policy of the axi4stream_transaction. Delay policy can be XIL_AXI4STREAM_DELAY_INSERTION_ALWAYS or XIL_AXI4STREAM_DELAY_INSERTION_FROM_IDLE.&nbsp; Please refer xil_axi4stream_xfer_delay_insertion_policy_t for delay policy explanation.</div></div>",219:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype219\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_delay and max_delay of the transaction</div></div>",220:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype220\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">There is a delay between the driver get the transaction and it starts to drive the data onto data bus.&nbsp; This delay is randomized in the range of min_delay and max_delay. set_delay_range is to set min_delay and max_delay of the axi4stream_transaction which late is used to generate delay when randomization of axi4stream_transaction is being called.</div></div>",221:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype221\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_strb_array_all_disabled();</div></div><div class=\"TTSummary\">Sets all strobe bits to 0 when HAS_STRB is on</div></div>",222:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype222\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_strb_array_all_enabled();</div></div><div class=\"TTSummary\">Sets all strobe bits to 1 when HAS_STRB is on</div></div>",223:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype223\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_keep_array_all_disabled();</div></div><div class=\"TTSummary\">Sets all keep bits to 0 when HAS_KEEP is on</div></div>",224:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype224\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_keep_array_all_enabled();</div></div><div class=\"TTSummary\">Sets all keep bits to 1 when HAS_KEEP is on</div></div>",225:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype225\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> post_randomize();</div></div><div class=\"TTSummary\">Sets final value of strobe of the transaction</div></div>"});