﻿NDSummary.OnToolTipsLoaded("svClass:axi4stream_vif_proxy",{240:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI4STREAM VIF Proxy Object. It has virtual interface for AXI4STREAM VIP interface. Drivers of AXI4STREAM VIP drive transaction/ready onto AXI4STREAM VIP bus interface through APIs(such as&nbsp; put_transaction) of this class, monitor of AXI4STREAM VIP collects AXI4STREAM interface information and convert it into transaction through APIs(get_transaction) in this class.</div></div>",242:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype242\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task wait_aclks(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_uint&nbsp;</td><td class=\"PName last\">cnt</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Waits specified amount of posedge aclk occur</div></div>",243:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype243\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_posedge_aclk();</div></div><div class=\"TTSummary\">Waits posedge of ACLK of m_vif</div></div>",244:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype244\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_posedge_aclk_with_hold();</div></div><div class=\"TTSummary\">Waits posedge of ACLK of m_vif and then wait hold_time</div></div>",245:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype245\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_negedge_aclk();</div></div><div class=\"TTSummary\">Waits negedge of ACLK of m_vif</div></div>",246:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype246\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_areset_deassert();</div></div><div class=\"TTSummary\">Waits areset to be deasserted</div></div>",247:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype247\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_boolean_t get_drive_x();</div></div><div class=\"TTSummary\">Returns 1 if dummy_drive_type is XIL_AXI4STREAM_VIF_DRIVE_X, else returns 0</div></div>",248:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype248\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> cheap_random();</div></div><div class=\"TTSummary\">Generate simplified randomization of xid,xdest and xlast of VIF when user define XIL_DO_NOT_USE_ADV_RANDOMIZATION</div></div>",249:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype249\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi4stream_vif_dummy_drive_t get_dummy_drive_type();</div></div><div class=\"TTSummary\">Get Dummy Drive Type of m_vif</div></div>",250:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype250\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_valid_asserted();</div></div><div class=\"TTSummary\">Waits TVALID of m_vif asserted</div></div>",251:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype251\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi4stream_vif_mem_proxy&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new axi4stream vif proxy</div></div>",252:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype252\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task run_phase();</div></div><div class=\"TTSummary\">Starts control processes for operation</div></div>",253:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype253\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi4stream_ulong get_current_clk_count();</div></div><div class=\"TTSummary\">Returns clk_edge_counter</div></div>",254:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype254\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> time get_current_edge_time();</div></div><div class=\"TTSummary\">Returns clk_edge_time</div></div>",255:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype255\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_drive_x();</div></div><div class=\"TTSummary\">Sets Dummy Drive type to be XIL_AXI4STREAM_VIF_DRIVE_X</div></div>",256:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype256\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_dummy_drive_type(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi4stream_vif_dummy_drive_t&nbsp;</td><td class=\"PName last\">inp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets Dummy Drive Type</div></div>",257:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype257\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> assign_vi (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">virtual interface</span> axi4stream_vip_if `</td><td class=\"PType\">XIL_AXI4STREAM_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">) ;</td></tr></table></div></div><div class=\"TTSummary\">Assigns m_vif</div></div>",258:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype258\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> put_noise();</div></div><div class=\"TTSummary\">Puts noise on bus</div></div>",259:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype259\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> reset();</div></div><div class=\"TTSummary\">Sets TVALID to be 0 and puts noise onto bus</div></div>",260:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype260\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> put_transaction(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi4stream_transaction&nbsp;</td><td class=\"PName last\">trans</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Puts transaction information onto bus</div></div>",261:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype261\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> axi4stream_monitor_transaction get_transaction();</div></div><div class=\"TTSummary\">Collects m_vif information and returns it to transaction class</div></div>",262:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype262\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_valid();</div></div><div class=\"TTSummary\">Sets valid of m_vif to be 1</div></div>",263:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype263\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_valid();</div></div><div class=\"TTSummary\">Sets valid of m_vif to be 0</div></div>",264:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype264\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_ready();</div></div><div class=\"TTSummary\">Sets ready of m_vif to be 1</div></div>",265:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype265\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_ready();</div></div><div class=\"TTSummary\">Sets ready of m_vif to be 0</div></div>",266:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype266\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_live_valid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if TVALID of m_vif is 1, else returns 0</div></div>",267:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype267\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_live_valid_asserted();</div></div><div class=\"TTSummary\">Wait TVALID of m_vif is 1</div></div>",268:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype268\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_ready_asserted();</div></div><div class=\"TTSummary\">If HAS_TRAEADY is on, returns 1 if TREADY of clock block in m_vif is 1, else returns 0 If HAS_TRAEADY is off, returns 1.</div></div>",269:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype269\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_valid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if TVALID of clock block in m_vif is 1, else returns 0</div></div>",270:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype270\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_areset_asserted();</div></div><div class=\"TTSummary\">Returns 1 if ARESET_N of clock block in m_vif is 0, else returns 0</div></div>",271:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype271\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_areset_asserted();</div></div><div class=\"TTSummary\">Waits negedge of ARSET_N of m_vif</div></div>",272:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype272\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_valid_sampled();</div></div><div class=\"TTSummary\">Waits till TVALID is sampled</div></div>",273:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype273\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_tx_accepted();</div></div><div class=\"TTSummary\">Waits till TREADY/TAVLID handshake occurs</div></div>",274:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype274\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_tx_accepted();</div></div><div class=\"TTSummary\">Returns 1 if TREADY/TVALID handshake occurs, otherwise returns 0</div></div>"});