﻿NDSummary.OnToolTipsLoaded("svClass:axi_monitor",{885:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">When active the AXI Monitor will record transactions that are presented on the virtual interface. It does below functions: Monitors all 5 AXI channels: AW, AR, R, W, and B.&nbsp; Collects and re-orders R Channel beats and returns a completed transaction when the RLAST is accepted Collects and re-orders B Channel response and returns a completed transaction when the B channel is accepted Transaction based protocol checking.</div></div>",887:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">xil_analysis_port #(axi_monitor_transaction)&nbsp; item_collected_port; provides methods for axi monitor transaction.</div></div>",889:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype889\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span> (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_monitor&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new monitor object. initalize the original settings and pass the input name as the montior instance name.</div></div>",890:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype890\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi_vif_mem_proxy `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Assigns input virtual interface vif to the virtual interface of the monitor.</div></div>",891:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype891\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_vif_axi_version_t get_axi_version();</div></div><div class=\"TTSummary\">Returns the value of AXI version of the transaction of axi_monitor. please refer xil_axi_vif_axi_version_t for possible axi version.</div></div>",892:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype892\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_axi_version_name();</div></div><div class=\"TTSummary\">Returns the enum string name of AXI version of the transaction of axi_monitor. please refer xil_axi_vif_axi_version_t for possible axi version</div></div>",893:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype893\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_wr_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the maximum number of WRITE transactions which axi_monitor can accept. Usually user set this depth from the agent which will automatically set it\'s driver/monitor</div></div>",894:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype894\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_wr_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of WRITE transactions that the Driver will have in flight at one time.</div></div>",895:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype895\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_rd_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the maximum number of READ transactions which axi_monitor can accept. Usually user set this depth from the agent which will automatically set it\'s driver/monitor</div></div>",896:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype896\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_rd_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of READ transactions that the Driver will have in flight at one time.</div></div>",897:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype897\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> enable_transaction_depth_checks();</div></div><div class=\"TTSummary\">Turn on checker for comparison of current write/read transaction depth against maximum wr_transaction_depth/rd_transaction_depth of axi_monitor.</div></div>",898:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype898\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> disable_transaction_depth_checks();</div></div><div class=\"TTSummary\">Turn off checker for comparison of current write/read transaction depth against maximum wr_transaction_depth/rd_transaction_depth of axi_monitor.</div></div>",899:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype899\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_transaction_depth_check_status();</div></div><div class=\"TTSummary\">Returns transaction_depth_checks_enabled value of axi_monitor. If user is not sure whether transaction_depth_checks_enabled is on or off, This API can be called to serve this purpose.</div></div>",900:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype900\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> disable_exclusive_checks();</div></div><div class=\"TTSummary\">Turn off current agent\'s exclusive transfer checks</div></div>",901:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype901\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> enable_exclusive_checks();</div></div><div class=\"TTSummary\">Turn on current agent\'s exclusive transfer checks</div></div>",902:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype902\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_num_rd_transactions_inflight();</div></div><div class=\"TTSummary\">Returns number of read transaction in flight</div></div>",903:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype903\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_num_wr_transactions_inflight();</div></div><div class=\"TTSummary\">Returns number of write transaction in flight</div></div>",904:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype904\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task run_phase();</div></div><div class=\"TTSummary\">Start control processes for operation</div></div>",905:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype905\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_phase();</div></div><div class=\"TTSummary\">Stops all control processes.</div></div>",906:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype906\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_monitor_transaction create_transaction (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_transaction&quot;</span>,</td></tr><tr><td class=\"PType first\">xil_axi_cmd_t&nbsp;</td><td class=\"PName\">dir</td><td></td><td class=\"last\"></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns an AXI monitor transaction class that has been &quot;newed&quot;</div></div>"});