﻿NDSummary.OnToolTipsLoaded("svClass:axi_mst_agent",{969:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI Master Agent.</div></div>",971:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">axi_monitor&nbsp; `AXI_PARAM_ORDER monitor;</div></div>",973:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype973\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span> (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_mst_agent&quot;</span>,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">virtual interface</span> axi_vip_if `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName\">vif</td><td></td><td class=\"last\"></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create an AXI Master Agent,~name~ is the instance name and axi_vip_if is the interface in the design.&nbsp; Please see PG267 for how to find the interface in design hierarchy.</div></div>",974:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype974\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_verbosity(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_verbosity&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the verbosity of the axi_mst_agent and all sub classes to determine whether the information will be printed out or not. refer xil_info for verbosity level setting.</div></div>",975:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype975\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_agent_tag(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the tag of the axi_mst_agent and all sub classes. If more than one VIPs(in master mode) being used in the same testbench, User can use set_agent_tag with different tag to tell where exactly the log message comes from.</div></div>",976:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype976\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi_vif_mem_proxy `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the Agent\'s virtual interface. This is the interface that will be monitored and/or driven.</div></div>",977:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype977\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_wr_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of WRITE transactions that the Agent will have in flight at one time.</div></div>",978:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype978\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_wr_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of WRITE transactions that the Agent will have in flight at one time.</div></div>",979:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype979\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_rd_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of READ transactions that the Agent will have in flight at one time.</div></div>",980:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype980\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_rd_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of READ transactions that the Agent will have in flight at one time.</div></div>",981:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype981\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> enable_transaction_depth_checks();</div></div><div class=\"TTSummary\">Turn on current agent\'s transaction depth checks and its monitor\'s enable_transaction_depth_checks</div></div>",982:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype982\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> disable_transaction_depth_checks();</div></div><div class=\"TTSummary\">Turn off current agent\'s transaction depth check and its monitor\'s enable_transaction_depth_checks</div></div>",983:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype983\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task start_monitor();</div></div><div class=\"TTSummary\">Enables the monitor in this agent to start collecting data.</div></div>",984:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype984\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task start_master();</div></div><div class=\"TTSummary\">Enables the monitor, READ driver and WRITE Driver in this agent to start collecting data.&nbsp; The drivers will only issue transactions when the send functions are called.</div></div>",985:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype985\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_master();</div></div><div class=\"TTSummary\">Disables the READ and WRITE drivers. Once disabled, no further action will occur by the drivers.</div></div>",986:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype986\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task halt_master();</div></div><div class=\"TTSummary\">Allows for all inflight transactions to complete and no new transaction will be serviced. All other transactions will halt.</div></div>",987:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype987\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task resume_master();</div></div><div class=\"TTSummary\">Resumes processing of the pending transactions.</div></div>",988:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype988\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_monitor();</div></div><div class=\"TTSummary\">Disables the monitor in this agent from start collecting data. . Once disabled, no further action will occur by the monitor.</div></div>",989:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype989\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task wait_drivers_idle();</div></div><div class=\"TTSummary\">This blocking function will not return until all the downstream transactions have completed.</div></div>",990:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype990\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task send_multi_wrbursts(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">num_xfers,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">start_addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">myid,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName last\">mysize,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName last\">mylen,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName last\">myburst,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">bit&nbsp;</td><td class=\"PName last\">no_xfer_delays</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Convenience function to generate a series of same type of transactions.</div></div>",991:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype991\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task send_multi_rand_wrbursts(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">num_xfers,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">bit&nbsp;</td><td class=\"PName\">no_xfer_delays</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Convenience function to generate a series of random transactions.</div></div>",992:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype992\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task send_multi_rdbursts(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">num_xfers,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">start_addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">myid,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName last\">mysize,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName last\">mylen,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName last\">myburst,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">bit&nbsp;</td><td class=\"PName last\">no_xfer_delays</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Convenience function to generate a series of same type of transactions transactions.</div></div>",993:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype993\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task send_multi_rand_rdbursts(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">num_xfers,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">bit&nbsp;</td><td class=\"PName\">no_xfer_delays</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Convenience function to generate a series of random transactions.</div></div>",994:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype994\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task AXI4_READ_BURST (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName last\">len,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName last\">size,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName last\">burst,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_lock_t&nbsp;</td><td class=\"PName last\">lock,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cache_t&nbsp;</td><td class=\"PName last\">cache,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_prot_t&nbsp;</td><td class=\"PName last\">prot,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_region_t&nbsp;</td><td class=\"PName last\">region,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_qos_t&nbsp;</td><td class=\"PName last\">qos,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">aruser,</td></tr><tr><td class=\"PModifierQualifier first\">output bit [</td><td class=\"PType\"><span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">4096</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">data,</td></tr><tr><td class=\"PModifierQualifier first\">output xil_axi_resp_t [</td><td class=\"PType\"><span class=\"SHNumber\">255</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">resp,</td></tr><tr><td class=\"PModifierQualifier first\">output xil_axi_data_beat [</td><td class=\"PType\"><span class=\"SHNumber\">255</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">ruser</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This task does a full read process for AXI4.It is composed of a series of tasks and functions.&nbsp; It first creates transaction from master read driver,sets up the transaction, sends it and then waits till response back.&nbsp; This task returns when the read transaction is complete.</div></div>",995:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype995\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task AXI3_READ_BURST (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName last\">len,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName last\">size,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName last\">burst,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_lock_t&nbsp;</td><td class=\"PName last\">lock,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cache_t&nbsp;</td><td class=\"PName last\">cache,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_prot_t&nbsp;</td><td class=\"PName last\">prot,</td></tr><tr><td class=\"PModifierQualifier first\">output bit [</td><td class=\"PType\"><span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">2048</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">data,</td></tr><tr><td class=\"PModifierQualifier first\">output xil_axi_resp_t [</td><td class=\"PType\"><span class=\"SHNumber\">15</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">resp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This task does a full read process for AXI3. It is composed of a series of tasks and functions.&nbsp; It first creates transaction from master read driver,sets up the transaction, sends it and then waits till response back.&nbsp; This task returns when the read transaction is complete.</div></div>",996:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype996\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task AXI4LITE_READ_BURST (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_prot_t&nbsp;</td><td class=\"PName last\">prot,</td></tr><tr><td class=\"PModifierQualifier first\">output bit [</td><td class=\"PType\"><span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">8</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">data,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_resp_t&nbsp;</td><td class=\"PName last\">resp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This task does a full read process for AXI4LITE. It is composed of the task AXI_READ_BURST_BLOCKING with only addr, prot,data and resp. all other inputs are set to be either 0 or AXI4LITE Value This task returns when the read transaction is complete.</div></div>",997:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype997\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task AXI4_WRITE_BURST (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName last\">len,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName last\">size,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName last\">burst,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_lock_t&nbsp;</td><td class=\"PName last\">lock,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cache_t&nbsp;</td><td class=\"PName last\">cache,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_prot_t&nbsp;</td><td class=\"PName last\">prot,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_region_t&nbsp;</td><td class=\"PName last\">region,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_qos_t&nbsp;</td><td class=\"PName last\">qos,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">awuser,</td></tr><tr><td class=\"PModifierQualifier first\">input bit [</td><td class=\"PType\"><span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">4096</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">data,</td></tr><tr><td class=\"PModifierQualifier first\">input xil_axi_data_beat [</td><td class=\"PType\"><span class=\"SHNumber\">255</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">wuser,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_resp_t&nbsp;</td><td class=\"PName last\">resp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This task does a full write process for AXI4. It is composed of AXI4_WRITE_BURST_BLOCKING with inputs suits for AXI4.This task returns when the complete write transaction is complete.</div></div>",998:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype998\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task AXI3_WRITE_BURST (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName last\">len,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName last\">size,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName last\">burst,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_lock_t&nbsp;</td><td class=\"PName last\">lock,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cache_t&nbsp;</td><td class=\"PName last\">cache,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_prot_t&nbsp;</td><td class=\"PName last\">prot,</td></tr><tr><td class=\"PModifierQualifier first\">input bit [</td><td class=\"PType\"><span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">2048</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">data,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_resp_t&nbsp;</td><td class=\"PName last\">resp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This task does a full write process for AXI3. It is composed of AXI4_WRITE_BURST_BLOCKING with inputs suits for AXI3.This task returns when the complete write transaction is complete.</div></div>",999:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype999\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task AXI4LITE_WRITE_BURST (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_prot_t&nbsp;</td><td class=\"PName last\">prot,</td></tr><tr><td class=\"PModifierQualifier first\">input bit [</td><td class=\"PType\"><span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">8</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">data,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_resp_t&nbsp;</td><td class=\"PName last\">resp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This task does a full write process for AXI4LITE. It is composed of AXI4_WRITE_BURST_BLOCKING with inputs suits for AXI4LITE.This task returns when the complete write transaction is complete.</div></div>",1000:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1000\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task set_nobackpressure_readies();</div></div><div class=\"TTSummary\">Convenience function to set the RREADY/BREADY of the master to not apply any backpressure to the simulation.</div></div>"});