﻿NDSummary.OnToolTipsLoaded("svClass:axi_mst_wr_driver",{907:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI Master Write Driver object.</div></div>",909:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">axi_vif_mem_proxy `AXI_PARAM_ORDER&nbsp; vif_proxy; AXI VIF Proxy Class</div></div>",911:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype911\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_mst_wr_driver&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new AXI master write driver axi_mst_wr_driver. ~name~ is the name of the instance.</div></div>",912:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype912\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi_vif_mem_proxy `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Assigns the virtual interface vif to the virtual interface of axi_mst_wr_driver.</div></div>",913:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype913\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_bready_gen(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen_t&nbsp;</td><td class=\"PName last\">new_gen</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets bready_gen of the AXI master write driver. There are three ways for bready generation in AXI master write driver.&nbsp; 1.User can first create a axi_ready_gen, customerize it and then use set_bready_gen to send it to AXI master write driver.User can\'t fill in more than 500 axi_ready_gen at one time, otherwise it will error out.</div></div>",914:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype914\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> axi_ready_gen_t get_bready_gen();</div></div><div class=\"TTSummary\">Returns bready_gen of the AXI master write driver</div></div>",915:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype915\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_forward_progress_timeout_value (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_timeout</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of cycles that the driver will wait for AW/W/B accepted until it will flag a watch dog error of the axi_mst_wr_driver. Default value is 50000. Setting this to a very large value will cause a hung simulation to continue for a longer time.&nbsp; Setting this to a very small number may not allow enough time for simulation to respond.</div></div>",916:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype916\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_forward_progress_timeout_value ();</div></div><div class=\"TTSummary\">Returns the number of cycles that the driver will wait for AW/W/B accepted until it will flag a watch dog error of the axi_mst_wr_driver. Default value is 50000 and user can use set_forward_progress_timeout_value to change it.</div></div>",917:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype917\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_waiting_valid_timeout_value (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_timeout</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets waiting_valid_timeout_value of the &lt;axi_mst_wr_driver&gt;.waiting_valid_timeout_value is used for driver to wait a certain number of cycles for bvalid/bready, awvalid/awready and wvalid/wready handshake occurs before it time out.</div></div>",918:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype918\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_waiting_valid_timeout_value ();</div></div><div class=\"TTSummary\">Returns waiting_valid_timeout_value of the axi_mst_wr_driver. waiting_valid_timeout_value is used for driver to wait a certain number of cycles for bvalid/bready, awvalid/awready and wvalid/wready handshake occurs before it time out.</div></div>",919:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype919\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_depth</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of transactions that the Driver will have in flight at one time.</div></div>",920:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype920\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of transactions that the Driver will have in flight at one time.</div></div>",921:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype921\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_awaddr_watchdog_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_depth</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets awaddr_watchdog_delay of the axi_mst_wr_driver. When axi_transaction\'s xfer_wrcmd_order is XIL_AXI_WRCMD_ORDER_DATA_BEFORE_CMD and get_allow_data_before_cmd() greater than zero, AW channel of axi_mst_wr_driver will fire watchdog AXI_WR_MST_ORDER_DATA_BEFORE_CMD WATCHDOG fired if it doesn\'t see enough beat_counts as desired after waiting awaddr_watchdog_delay clock cycles.</div></div>",922:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype922\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_awaddr_watchdog_delay();</div></div><div class=\"TTSummary\">Returns awaddr_watchdog_delay of the &lt;axi_mst_wr_driver&gt;.awaddr_watchdog_delay is the number of clock cycles axi_mst_wr_driver waits before it fires watchdog AXI_WR_MST_ORDER_DATA_BEFORE_CMD when AW channel does not have enough payload beats.</div></div>",923:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype923\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_adjust_addr_delay_enabled();</div></div><div class=\"TTSummary\">Returns the current state of adjust_addr_delay_enabled.</div></div>",924:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype924\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_adjust_addr_delay_enabled(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_boolean_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of adjust_addr_delay_enabled of the transaction.</div></div>",925:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype925\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_adjust_data_beat_delay_enabled();</div></div><div class=\"TTSummary\">Returns the current state of adjust_data_beat_delay_enabled.</div></div>",926:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype926\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_adjust_data_beat_delay_enabled(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_boolean_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of adjust_data_beat_delay_enabled of the transaction.</div></div>",927:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype927\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_boolean_t is_driver_idle();</div></div><div class=\"TTSummary\">Returns TRUE if driver is idle(no outstanding write command from write address channel, no outstanding data from write data channel,no outstanding write response from write response channel), else FALSE.</div></div>",928:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype928\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_num_transactions_inflight();</div></div><div class=\"TTSummary\">Returns number of transactions in flight</div></div>",929:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype929\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task run_phase();</div></div><div class=\"TTSummary\">Start control processes for operation</div></div>",930:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype930\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_phase();</div></div><div class=\"TTSummary\">Stops all control processes.</div></div>",931:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype931\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task halt_phase();</div></div><div class=\"TTSummary\">Allows for all inflight transactions to complete and no new transaction will be serviced. All other transactions will halt in axi_mst_wr_driver.</div></div>",932:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype932\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task resume_phase();</div></div><div class=\"TTSummary\">Resumes processing of the pending transactions in &lt;axi_mst_rd_drive&gt;.</div></div>",933:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype933\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sends the AXI transaction to axi_mst_wr_driver. Usually user would create a new axi_transaction by calling create_transaction of axi_mst_wr_driver, either randomize the transaction or set it up. Then it calls send to send the transaction to axi_mst_wr_driver.&nbsp; It is a blocking process. please refer example design for the usage</div></div>",934:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype934\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task wait_rsp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This blocking function will not return until driver send back response transaction of &lt;axi_mst_wr_driver&gt;.please refer example design for the usage.&nbsp; NOTE: The driver_return_item_policy of the transaction must be set to XIL_AXI_PAYLOAD_RETURN or XIL_AXI_CMD_PAYLOAD_RETURN. The default is NO_RETURN and this policy causes wait_rsp to hang</div></div>",935:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype935\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_transaction create_transaction (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_transaction&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns an axi transaction class that has been &quot;newed&quot; of &lt;axi_mst_wr_driver&gt;.please refer example design for the usage.</div></div>",936:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype936\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send_bready(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sends the ready structure to the axi_mst_wr_driver for controlling the READY channel.&nbsp; Usually user would create a new axi_ready_gen by calling create_ready of axi_mst_wr_driver, either randomize the bready or set it up manually. Then it calls send to send the bready to axi_mst_wr_driver.</div></div>",937:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype937\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_ready_gen create_ready (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_ready&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns a ready class that has been &quot;newed&quot;.</div></div>",938:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype938\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task wait_driver_idle();</div></div><div class=\"TTSummary\">This is a blocking task which will wait until there are no outstanding transactions in the axi_mst_wr_driver. This means that all the transactions send to the driver have received a corresponding B channel response.</div></div>"});