﻿NDSummary.OnToolTipsLoaded("svClass:axi_ready_gen",{766:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI Ready generation object.&nbsp; Ready signals of write command channel, write data channel, write response channel , read command channel and read data channel are generated independently from other attributes.&nbsp; This class is being used to generate all kinds of different patterns of ready signal which user wants. Please refer section READY Generation of PG267 for more details about how to generate ready.</div></div>",768:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype768\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_ready_gen&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new AXI ready generation</div></div>",769:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype769\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> reset_to_defaults();</div></div><div class=\"TTSummary\">Reset all variables in ready generation to default value. please refer xil_axi_ready_gen_policy_t , xil_axi_ready_rand_policy_t for more details about ready generation policy.</div></div>",770:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype770\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> copy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">axi_ready_gen&nbsp;</td><td class=\"PName last\">rhs</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Copies the contents of the input ready generation to the current ready generation</div></div>",771:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype771\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> axi_ready_gen my_clone ();</div></div><div class=\"TTSummary\">Clones the current ready generation and returns a handle to the new generation</div></div>",772:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype772\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> convert2string();</div></div><div class=\"TTSummary\">Returns a format of string of Ready information for axi_ready_gen</div></div>",773:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype773\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_use_variable_ranges();</div></div><div class=\"TTSummary\">Sets use_variable_ranges to be TRUE. This is to set that get_low_time, get_high_time, get_event_count are randomly generated between the range of minimum and maximum value</div></div>",774:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype774\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_use_variable_ranges();</div></div><div class=\"TTSummary\">Sets use_variable_ranges to be FALSE.This is to set that get_low_time, get_high_time, get_event_count are returned with current low_time, high_time, event_count if ready_policy is not RANDOM</div></div>",775:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype775\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_use_variable_ranges();</div></div><div class=\"TTSummary\">Returns the current state of the variable range use feature.</div></div>",776:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype776\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_ready_policy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ready_gen_policy_t&nbsp;</td><td class=\"PName last\">value</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the policy of axi_ready_gen. refer xil_axi_ready_gen_policy_t for policy. if policy is XIL_AXI_READY_GEN_NO_BACKPRESSURE, Then it returns</div></div>",777:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype777\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_ready_gen_policy_t get_ready_policy();</div></div><div class=\"TTSummary\">Returns the current ready generation policy of axi_ready_gen. refer xil_axi_ready_gen_policy_t for policy information</div></div>",778:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype778\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_event_cycle_count_reset(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">value</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets event_cycle_count_reset value of ready generation</div></div>",779:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype779\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_event_cycle_count_reset();</div></div><div class=\"TTSummary\">Returns the current event_cycle_count_reset of axi_ready_gen. In ready generation,event_cycle_count_reset is used to reset event_counter(count number of ready/valid handshake) to zero.</div></div>",780:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype780\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> get_low_time_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_low_time and max_low_time of the ready generation. low_time is how many cycles ready stay low.</div></div>",781:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype781\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_low_time_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_low_time and max_low_time of the ready generation</div></div>",782:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype782\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_low_time();</div></div><div class=\"TTSummary\">Returns low time of the current ready generation. if ready policy is XIL_AXI_READY_GEN_NO_BACKPRESSURE, low time is 0, else if ready policy is XIL_AXI_READY_GEN_RANDOM or get_use_variable_ranges is TRUE, low is the randomly generated low time.&nbsp; else low time is low_time of current ready generation.&nbsp; low_time is how many cycles ready stay low.</div></div>",783:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype783\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_low_time(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the low time of the ready generation</div></div>",784:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype784\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> get_high_time_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_high_time and max_high_time of the ready generation. high_time is how many cycles ready stay high.</div></div>",785:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype785\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_high_time_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_high_time and max_high_time of the ready generation. high_time is how many cycles ready stay high.</div></div>",786:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype786\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_high_time();</div></div><div class=\"TTSummary\">Returns high time of axi_ready_gen. If ready policy is XIL_AXI_READY_GEN_NO_BACKPRESSURE, returns 1, else if ready policy is XIL_AXI_READY_GEN_RANDOM or get_use_variable_ranges is TRUE, high time is the randomly generated high time.&nbsp; else high time is high_time of current ready generation.High_time is how many cycles ready stay high.</div></div>",787:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype787\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_high_time(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the high time of the ready generation</div></div>",788:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype788\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> get_event_count_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_event_count and max_event_count of the ready generation. event count is used when policy is XIL_AXI_READY_RAND_AFTER_VALID_EVENTS. refer xil_axi_ready_gen_policy_t about how event_count works</div></div>",789:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype789\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_event_count_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_event_count and max_event_count of the ready generation. event count is used when policy is XIL_AXI_READY_RAND_AFTER_VALID_EVENTS. refer xil_axi_ready_gen_policy_t about how event_count works.</div></div>",790:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype790\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_event_count();</div></div><div class=\"TTSummary\">Returns event_count of axi_ready_gen. event count is used when policy is XIL_AXI_READY_RAND_AFTER_VALID_EVENTS. refer xil_axi_ready_gen_policy_t about how event_count works.</div></div>",791:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype791\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_event_count(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of events that ready stays at high. event count is used when policy is XIL_AXI_READY_RAND_AFTER_VALID_EVENTS. refer xil_axi_ready_gen_policy_t about how event_count works.</div></div>",792:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype792\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_ready_rand_policy_t get_ready_rand_policy();</div></div><div class=\"TTSummary\">Returns ready_rand_policy of the ready generation. refer xil_axi_ready_rand_policy_t for more information.</div></div>"});