﻿NDSummary.OnToolTipsLoaded("svClass:axi_slv_agent",{1094:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI Slave Agent.</div></div>",1096:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">axi_monitor&nbsp; `AXI_PARAM_ORDER monitor;</div></div>",1098:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1098\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span> (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_slv_agent&quot;</span>,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">virtual interface</span> axi_vip_if `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName\">vif</td><td></td><td class=\"last\"></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create an AXI Slave Agent. ~name~ is the instance name and axi_vip_if is the interface in the design.&nbsp; Please see PG267 for how to find the interface in design hierarchy.</div></div>",1099:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1099\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_verbosity(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_verbosity&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the verbosity of the axi_slv_agent and all sub classes to determine whether the information will be printed out or not.&nbsp; refer xil_info for verbosity level setting.</div></div>",1100:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1100\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_agent_tag(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the tag of the axi_slv_agent and all sub classes. If more than one VIPs(in slave mode) being used in the same testbench, User can use set_agent_tag with different tag to tell where exactly the log message comes from.</div></div>",1101:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1101\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi_vif_mem_proxy `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the Agent\'s virtual interface. This is the interface that will be monitored and/or driven.</div></div>",1102:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1102\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_wr_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of WRITE transactions that the Agent will have in flight at one time.</div></div>",1103:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1103\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_wr_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of WRITE transactions that the Agent will have in flight at one time.</div></div>",1104:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1104\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_rd_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of READ transactions that the Agent will have in flight at one time.</div></div>",1105:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1105\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_rd_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of READ transactions that the Agent will have in flight at one time.</div></div>",1106:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1106\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> enable_transaction_depth_checks();</div></div><div class=\"TTSummary\">Turn on current agent\'s transaction depth check and its monitor\'s enable_transaction_depth_checks</div></div>",1107:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1107\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> disable_transaction_depth_checks();</div></div><div class=\"TTSummary\">Turn off current agent\'s transaction depth check and its monitor\'s enable_transaction_depth_checks</div></div>",1108:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1108\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task start_monitor();</div></div><div class=\"TTSummary\">Enables the monitor in this agent to start collecting data.</div></div>",1109:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1109\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task start_slave();</div></div><div class=\"TTSummary\">Enables the READ and WRITE drivers in this agent to start collecting data.&nbsp; The drivers will only issue transactions when the send functions are called.</div></div>",1110:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1110\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_slave();</div></div><div class=\"TTSummary\">Disables the READ and WRITE drivers of the slave. Once disabled, no further action will occur by the drivers.</div></div>",1111:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1111\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_monitor();</div></div><div class=\"TTSummary\">Disables the monitor in this agent from start collecting data. . Once disabled, no further action will occur by the monitor.</div></div>",1112:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1112\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task set_nobackpressure_readies();</div></div><div class=\"TTSummary\">Convenience function to set the ARREADY/WREADY/AWREADY of the slave to not apply any backpressure to the simulation.</div></div>"});