﻿NDSummary.OnToolTipsLoaded("svClass:axi_slv_rd_driver",{1041:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI Slave Read Driver object.It does below:</div></div>",1043:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">axi_vif_mem_proxy `AXI_PARAM_ORDER&nbsp; vif_proxy; AXI VIF Proxy Class</div></div>",1045:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1045\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_slv_rd_driver&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create an AXI slave read driver</div></div>",1046:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1046\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_reorder_data_ability (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_reorder_ability_t&nbsp;</td><td class=\"PName last\">value</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets reorder_data_ability of the slave read driver. please refer &lt;set_xfer_preemptive_probability&gt; in&nbsp; axi_transaction for more information.</div></div>",1047:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1047\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_reorder_ability_t get_reorder_data_ability ();</div></div><div class=\"TTSummary\">Returns reorder_data_ability of the slave read driver. please refer &lt;set_xfer_preemptive_probability&gt; in&nbsp; axi_transaction for more information.</div></div>",1048:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1048\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi_vif_mem_proxy `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Assigns the virtual interface of the driver.</div></div>",1049:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1049\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_arready_gen(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen_t&nbsp;</td><td class=\"PName last\">new_method</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets arready of the AXI slave read driver. There are three ways for arready generation in AXI slave read driver.</div></div>",1050:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1050\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> axi_ready_gen_t get_arready_gen();</div></div><div class=\"TTSummary\">Returns the arready_gen of the slave read driver.</div></div>",1051:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1051\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_forward_progress_timeout_value (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_timeout</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of cycles that the driver will wait until it will flag a watch dog error of the axi_slv_rd_driver. Default value is 50000. Setting this to a very large value will cause a hung simulation to continue for a longer time.&nbsp; Setting this to a very small number may not allow enough time for simulation to respond.</div></div>",1052:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1052\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_forward_progress_timeout_value ();</div></div><div class=\"TTSummary\">Returns the number of cycles that the driver will wait&nbsp; until it will flag a watch dog error of the axi_slv_rd_driver. Default value is 50000 and user can use set_forward_progress_timeout_value to change it.</div></div>",1053:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1053\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_waiting_valid_timeout_value (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_timeout</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets waiting_valid_timeout_value of the slave read driver. waiting_valid_timeout_value is used for driver to wait a certain number of cycles for rvalid/rready handshake occurs before it time out.</div></div>",1054:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1054\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_waiting_valid_timeout_value ();</div></div><div class=\"TTSummary\">Returns waiting_valid_timeout_value of the Driver</div></div>",1055:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1055\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_depth</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the maximum number of READ transactions that the Driver will have in flight at one time.</div></div>",1056:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1056\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of READ transactions that the Driver will have in flight at one time.</div></div>",1057:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1057\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_num_pending_cmds();</div></div><div class=\"TTSummary\">Returns number of commands in pending</div></div>",1058:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1058\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_cmds_inflight();</div></div><div class=\"TTSummary\">Returns number of commands in flight</div></div>",1059:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1059\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task run_phase();</div></div><div class=\"TTSummary\">Start control processes for operation</div></div>",1060:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1060\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_phase();</div></div><div class=\"TTSummary\">Stops all control processes.</div></div>",1061:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1061\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_transaction create_transaction (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_transaction&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns an AXI transaction class that has been &quot;newed&quot;</div></div>",1062:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1062\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task get_rd_reactive (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">transfer</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns Read reactive transaction with read command information.&nbsp; When Slave VIP instantiate agent without memory, user can use this API to create an AXI transaction,fill in data information and send it back to Slave VIP interface.</div></div>",1063:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1063\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send_arready(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sends the ready structure to the driver for controlling the ARREADY channel. This is blocking process which will not return till this ready is being sent out.</div></div>",1064:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1064\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_ready_gen create_ready (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_ready&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns a ready class in the slave read driver that has been &quot;newed&quot; with instance name ~name~.</div></div>",1065:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1065\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sends the AXI transaction to the slave read driver. This is blocking process which will not return till this transaction is being sent out.</div></div>",1066:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1066\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task wait_rsp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This blocking function will not return until driver send back response transaction.&nbsp; Note: The driver_return_item_policy of the transaction must be set to XIL_AXI_PAYLOAD_RETURN or XIL_AXI_CMD_PAYLOAD_RETURN. The default is NO_RETURN and this policy causes wait_rsp to hang.</div></div>"});