﻿NDSummary.OnToolTipsLoaded("svClass:axi_slv_wr_driver",{1001:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI Slave Write Driver object.It does :</div></div>",1003:"<div class=\"NDToolTip TInformation Lsv\"><div class=\"TTSummary\">axi_vif_mem_proxy `AXI_PARAM_ORDER&nbsp; vif_proxy;AXI VIF Proxy Class</div></div>",1005:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1005\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_slv_wr_driver&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create an AXI slave write driver</div></div>",1006:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1006\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_vif(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">axi_vif_mem_proxy `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Assigns the virtual interface of the driver.</div></div>",1007:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1007\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_awready_gen(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen_t&nbsp;</td><td class=\"PName last\">new_gen</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets awready of the AXI slave write driver. There are three ways for awready generation in AXI slave write driver.</div></div>",1008:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1008\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> axi_ready_gen_t get_awready_gen();</div></div><div class=\"TTSummary\">Returns awready_gen</div></div>",1009:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1009\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_wready_gen(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen_t&nbsp;</td><td class=\"PName last\">new_gen</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets wready of the AXI slave write driver. There are three ways for wready generation in AXI slave write driver.</div></div>",1010:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1010\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> axi_ready_gen_t get_wready_gen();</div></div><div class=\"TTSummary\">Returns wready_gen</div></div>",1011:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1011\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_reorder_response_ability (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_reorder_ability_t&nbsp;</td><td class=\"PName last\">value</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets reorder_response_ability of the Driver. refer xil_axi_reorder_ability_t about reorder transaction.</div></div>",1012:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1012\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_reorder_ability_t get_reorder_response_ability ();</div></div><div class=\"TTSummary\">Returns reorder_response_ability of the Driver. refer xil_axi_reorder_ability_t about reorder transaction.</div></div>",1013:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1013\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_reorder_backoff_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the reordering backoff timer range of the slave write driver.&nbsp; Since the slave may pop the BRESP quicker than one is available, if there is only one entry then insert a backoff that will allow for some accumulation of time.&nbsp; so perhaps another BRESP will be ready to send. This time is randomized between min and max.</div></div>",1014:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1014\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_reorder_backoff_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Gets the reordering backoff timer range</div></div>",1015:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1015\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_forward_progress_timeout_value (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_timeout</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of cycles that the driver will wait for AW/W/B accepted until it will flag a watch dog error of the axi_slv_wr_driver. Default value is 50000. Setting this to a very large value will cause a hung simulation to continue for a longer time.&nbsp; Setting this to a very small number may not allow enough time for simulation to respond.</div></div>",1016:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1016\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_forward_progress_timeout_value ();</div></div><div class=\"TTSummary\">Returns the number of cycles that the driver will wait for AW/W/B accepted until it will flag a watch dog error of the axi_slv_wr_driver. Default value is 50000 and user can use set_forward_progress_timeout_value to change it.</div></div>",1017:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1017\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_waiting_valid_timeout_value (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_timeout</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets waiting_valid_timeout_value of the slave write driver. waiting_valid_timeout_value is used for driver to wait a certain number of cycles for bvalid/bready handshake occurs before it time out.</div></div>",1018:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1018\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_waiting_valid_timeout_value ();</div></div><div class=\"TTSummary\">Returns waiting_valid_timeout_value of the slave write driver. waiting_valid_timeout_value is used for driver to wait a certain number of cycles for bvalid/bready handshake occurs before it time out.</div></div>",1019:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1019\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_transaction_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_depth</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of WRITE transactions that the Driver will have in flight at one time.</div></div>",1020:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1020\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_transaction_depth();</div></div><div class=\"TTSummary\">Returns the maximum number of WRITE transactions that the Driver will have in flight at one time.</div></div>",1021:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1021\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_num_pending_cmds();</div></div><div class=\"TTSummary\">Returns number of commands in pending</div></div>",1022:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1022\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_cmds_inflight();</div></div><div class=\"TTSummary\">Returns number of commands in flight</div></div>",1023:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1023\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_xfer_wrcmd_order(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_xfer_wrcmd_order_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets wrcmd_order of the slave write driver. Refer xil_axi_xfer_wrcmd_order_t for order between write command and write data.</div></div>",1024:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1024\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_xfer_wrcmd_order_t get_xfer_wrcmd_order();</div></div><div class=\"TTSummary\">Returns wrcmd_order of the slave write driver.Refer xil_axi_xfer_wrcmd_order_t for order between write command and write data.</div></div>",1025:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1025\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_inbound_fifo_depth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets inbound_fifo_depth of the slave write driver for wready generation.In axi slave write driver, when write command order is not XIL_AXI_WRCMD_ORDER_CMD_BEFORE_DATA, wready generation mimics an inbound buffer of depth inbound_fifo_depth.Once wdata beat counts reach inbound_fifo_depth, it checks whether there is outstanding commands. If there is no pending command request,stop wready generation and wait till there is at least one active request.</div></div>",1026:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1026\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_inbound_fifo_depth();</div></div><div class=\"TTSummary\">Returns inbound_fifo_depth of the Driver</div></div>",1027:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1027\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_boolean_t is_driver_idle();</div></div><div class=\"TTSummary\">Returns TRUE if the Driver is idle, else FALSE</div></div>",1028:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1028\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_awaddr_watchdog_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_depth</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets awaddr_watchdog_delay of the slave write driver.When axi_transaction\'s xfer_wrcmd_order is XIL_AXI_WRCMD_ORDER_DATA_BEFORE_CMD, awready generation of axi_slv_wr_driver will fire watchdog AXI_WR_SLV_DATA_BEFORE_CMD_DEADLOCK WATCHDOG if it doesn\'t see wvalid assert high after waiting awaddr_watchdog_delay clock cycles.</div></div>",1029:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1029\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_awaddr_watchdog_delay();</div></div><div class=\"TTSummary\">Returns awaddr_watchdog_delay of the slave write driver.When axi_transaction\'s xfer_wrcmd_order is XIL_AXI_WRCMD_ORDER_DATA_BEFORE_CMD, awready generation of axi_slv_wr_driver will fire watchdog AXI_WR_SLV_DATA_BEFORE_CMD_DEADLOCK WATCHDOG if it doesn\'t see wvalid assert high after waiting awaddr_watchdog_delay clock cycles.</div></div>",1030:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1030\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_adjust_response_delay_enabled();</div></div><div class=\"TTSummary\">Returns the current state of adjust_response_delay_enabled of the transaction.</div></div>",1031:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1031\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_adjust_response_delay_enabled(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_boolean_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of adjust_response_delay_enabled of the transaction.</div></div>",1032:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1032\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task run_phase();</div></div><div class=\"TTSummary\">Start control processes for operation</div></div>",1033:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1033\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task stop_phase();</div></div><div class=\"TTSummary\">Stops all control processes.</div></div>",1034:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1034\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task get_wr_reactive (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">transfer</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns write reactive transaction with write command information.&nbsp; The slave VIP agent gets write transaction command information,fill in write response and send it back to Slave VIP interface.The usage of this API is shown below and it MUST be put in initial, forever procedure since get_wr_reactive is blocking, so does send. Please refer example design simset sim_allconfig for more details.</div></div>",1035:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1035\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_transaction create_transaction (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_transaction&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns an AXI transaction class that has been &quot;newed&quot;</div></div>",1036:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1036\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send_wready(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sends the ready structure to the driver for controlling the WREADY channel</div></div>",1037:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1037\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_ready_gen create_ready (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_ready&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns a ready class that has been &quot;newed&quot;.</div></div>",1038:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1038\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send_awready(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_ready_gen&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sends the ready structure to the slave write driver for controlling the AWREADY channel.his is blocking process which will not return till this ready is being sent out.</div></div>",1039:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1039\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task send(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sends the AXI transaction to the driver</div></div>",1040:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1040\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">task wait_rsp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">This blocking function will not return until driver send back response transaction.&nbsp; Note:The driver_return_item_policy of the transaction must be set to XIL_AXI_PAYLOAD_RETURN or XIL_AXI_CMD_PAYLOAD_RETURN. The default is NO_RETURN and this policy causes wait_rsp to hang.</div></div>"});