﻿NDSummary.OnToolTipsLoaded("svClass:axi_transaction",{535:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">The axi_transaction class is the base class of AXI protocol. It inherits all the methods of xil_sequence_item.</div></div>",537:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype537\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_transaction&quot;</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">protocol</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">addrw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">32</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">dataw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">32</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">idw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">awusrw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">wusrw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">busrw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">arusrw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">rusrw</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">supports_narrow</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_burst</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_lock</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_cache</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_region</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_prot</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_qos</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_wstrb</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_bresp</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span>,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">has_rresp</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">1</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new AXI transaction.</div></div>",538:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype538\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> copy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">axi_transaction&nbsp;</td><td class=\"PName last\">rhs</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Copies the contents of the input transaction to the current transaction</div></div>",539:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype539\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_type_name();</div></div><div class=\"TTSummary\">Returns the name of the class type</div></div>",540:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype540\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> axi_transaction my_clone ();</div></div><div class=\"TTSummary\">Clones the current transaction and returns a handle to the new transaction.</div></div>",541:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype541\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_protocol(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the protocol type of the transaction.&nbsp; update = 0 =&gt; protocol = XIL_VERSION_AXI4; update = 1 =&gt; protocol = XIL_VERSION_AXI3; update = 2 =&gt; protocol = XIL_VERSION_LITE;</div></div>",542:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype542\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_adjust_response_delay_enabled();</div></div><div class=\"TTSummary\">Returns the current state of adjust_response_delay_enabled of the transaction.</div></div>",543:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype543\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_adjust_response_delay_enabled(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_boolean_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of adjust_response_delay_enabled of the transaction.</div></div>",544:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype544\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_adjust_addr_delay_enabled();</div></div><div class=\"TTSummary\">Returns the current state of adjust_addr_delay_enabled of the transaction.</div></div>",545:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype545\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_adjust_addr_delay_enabled(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_boolean_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of adjust_addr_delay_enabled of the transaction.</div></div>",546:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype546\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_adjust_data_beat_delay_enabled();</div></div><div class=\"TTSummary\">Returns the current state of adjust_data_beat_delay_enabled of the transaction.</div></div>",547:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype547\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_adjust_data_beat_delay_enabled(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_boolean_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of adjust_data_beat_delay_enabled of the transaction.</div></div>",548:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype548\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_supports_narrow(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of supports_narrow of the transaction. Internal use only</div></div>",549:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype549\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_burst(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_burst of the transaction. Internal use only</div></div>",550:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype550\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_lock(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_lock of the transaction. Internal use only</div></div>",551:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype551\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_cache(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_cache of the transaction. Internal use only</div></div>",552:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype552\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_region(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_region of the transaction. Internal use only</div></div>",553:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype553\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_prot(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_prot of the transaction. Internal use only</div></div>",554:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype554\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_qos(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_qos of the transaction. Internal use only</div></div>",555:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype555\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_wstrb(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_wstrb of the transaction. Internal use only</div></div>",556:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype556\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_adjust_strb(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">sets the value of adjust_strb of the transaction. Internal use only</div></div>",557:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype557\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_bresp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_bresp of the transaction. Internal use only</div></div>",558:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype558\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_has_rresp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of has_rresp of the transaction. Internal use only</div></div>",559:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype559\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_supports_narrow();</div></div><div class=\"TTSummary\">Returns the value of supports_narrow of the transaction.</div></div>",560:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype560\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_burst();</div></div><div class=\"TTSummary\">Returns the value of has_burst of the transaction.</div></div>",561:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype561\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_lock();</div></div><div class=\"TTSummary\">Returns the value of has_lock of the transaction.</div></div>",562:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype562\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_cache();</div></div><div class=\"TTSummary\">Returns the value of has_cache of the transaction.</div></div>",563:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype563\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_region();</div></div><div class=\"TTSummary\">Returns the value of has_region of the transaction.</div></div>",564:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype564\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_prot();</div></div><div class=\"TTSummary\">Returns the value of has_prot of the transaction.</div></div>",565:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype565\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_qos();</div></div><div class=\"TTSummary\">Returns the value of has_qos of the transaction.</div></div>",566:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype566\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_wstrb();</div></div><div class=\"TTSummary\">Returns the value of has_wstrb of the transaction.</div></div>",567:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype567\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_adjust_strb();</div></div><div class=\"TTSummary\">Return the value of adjust_strb of the transaction.</div></div>",568:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype568\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_bresp();</div></div><div class=\"TTSummary\">Returns the value of has_bresp of the transaction.</div></div>",569:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype569\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_has_rresp();</div></div><div class=\"TTSummary\">Returns the value of has_rresp of the transaction.</div></div>",570:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype570\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_protocol();</div></div><div class=\"TTSummary\">Returns the value of protocol type of the transaction.</div></div>",571:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype571\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_addr_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of address width of the transaction. Internal use only</div></div>",572:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype572\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_addr_width();</div></div><div class=\"TTSummary\">Returns the value of address width of the transaction.</div></div>",573:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype573\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_data_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of WDATA/RDATA width of the transaction. Internal use only</div></div>",574:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype574\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_data_width();</div></div><div class=\"TTSummary\">Returns the value of WDATA/RDATA width of the transaction.</div></div>",575:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype575\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_id_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of ID width of the transaction. Internal use only</div></div>",576:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype576\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_id_width();</div></div><div class=\"TTSummary\">Returns the value of ID width of the transaction.</div></div>",577:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype577\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_awuser_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AWUSER width of the transaction. Internal use only</div></div>",578:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype578\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_awuser_width();</div></div><div class=\"TTSummary\">Returns the value of AWUSER width of the transaction.</div></div>",579:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype579\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_wuser_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of WUSER width of the transaction. Internal use only</div></div>",580:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype580\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_wuser_width();</div></div><div class=\"TTSummary\">Returns the value of WUSER width of the transaction.</div></div>",581:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype581\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_buser_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of BUSER width of the transaction. Internal use only</div></div>",582:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype582\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_buser_width();</div></div><div class=\"TTSummary\">Returns the value of BISER width of the transaction.</div></div>",583:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype583\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_aruser_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of ARUSER width of the transaction. Internal use only</div></div>",584:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype584\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_aruser_width();</div></div><div class=\"TTSummary\">Returns the value of ARUSER width of the transaction.</div></div>",585:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype585\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_ruser_width(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of RUSER width of the transaction. Internal use only</div></div>",586:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype586\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_ruser_width();</div></div><div class=\"TTSummary\">Returns the value of RUSER width of the transaction.</div></div>",587:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype587\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_vif_axi_version_t get_axi_version();</div></div><div class=\"TTSummary\">Returns the value of AXI version of the transaction. please refer xil_axi_vif_axi_version_t for possible axi version</div></div>",588:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype588\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_axi_version(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_vif_axi_version_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AXI VERSION of the transaction. Internal use only</div></div>",589:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype589\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_axi_version_name();</div></div><div class=\"TTSummary\">Returns the string name of the AXI version of the transaction.</div></div>",590:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype590\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_creation_time(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">time&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets creation_time of the transaction. Internal use only</div></div>",591:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype591\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> time get_creation_time();</div></div><div class=\"TTSummary\">Returns creation_time of the transaction.</div></div>",592:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype592\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> cmd_convert2string();</div></div><div class=\"TTSummary\">Returns the string of the AXI basic command properties which are cmd name,cmd_id,addr,id,length,size name, burst name, cache,lock name and prot. This is debugging tool to observe the transaction.</div></div>",593:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype593\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> cmd_sprintf();</div></div><div class=\"TTSummary\">Returns the string of the AXI basic command properties. refer cmd_convert2string&nbsp; for AXI basic command properties. This is debugging tool to observe the transaction.</div></div>",594:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype594\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> convert2string();</div></div><div class=\"TTSummary\">Returns the string of the AXI transaction. This is debugging tool to observe the transaction.</div></div>",595:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype595\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_submit_time(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">time&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets sumbit_time of the transaction.</div></div>",596:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype596\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> time get_submit_time();</div></div><div class=\"TTSummary\">Gets submit_time of the transaction.</div></div>",597:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype597\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_submit_cycle(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets sumbit_cycle of the transaction.</div></div>",598:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype598\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_ulong get_submit_cycle();</div></div><div class=\"TTSummary\">Gets submit_cycle of the transaction.</div></div>",599:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype599\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> get_region_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_region_t&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_region_t&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the MIN/MAX values that are used to constrain the AxREGION value.</div></div>",600:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype600\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_region_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_region_t&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_region_t&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the MIN/MAX values that are used to constrain the AxREGION value.</div></div>",601:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype601\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_num_bytes_in_transaction();</div></div><div class=\"TTSummary\">Returns the number of bytes DATA of the transaction based on the current properties of the transaction. It equals to (length +1) *&nbsp; size(in bytes)</div></div>",602:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype602\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_read_cmd(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName\">addr,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName\">burst</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\">XIL_AXI_BURST_TYPE_INCR,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">id</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName\">len</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName\">size</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\">XIL_AXI_SIZE_4BYTE</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Helper function to set the most common READ command properties of the transaction. Address,burst type,length, and size can be set through this command. This API is being used for READ Command only.</div></div>",603:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype603\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_write_cmd(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName\">addr,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName\">burst</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\">XIL_AXI_BURST_TYPE_INCR,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">id</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName\">len</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName\">size</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\">XIL_AXI_SIZE_4BYTE</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Helper function to set the most common WRITE command properties of the transaction. It sets address, burst type, id, length and size of the WRITE transaction. This API can only be used for WRITE Command only.</div></div>",604:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype604\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_cmd(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cmd_t&nbsp;</td><td class=\"PName\">cmd,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName\">addr,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName\">burst</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\">XIL_AXI_BURST_TYPE_INCR,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">id</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName\">len</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName\">size</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\">XIL_AXI_SIZE_4BYTE</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Helper function to set the most common command properties of the transaction. It sets cmd type,address, burst type, id, length and size of the transaction,</div></div>",605:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype605\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_region_t get_region ();</div></div><div class=\"TTSummary\">Returns the value of AxREGION of the transaction.</div></div>",606:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype606\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_region (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_region_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxREGION of the transaction.</div></div>",607:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype607\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_qos_t get_qos ();</div></div><div class=\"TTSummary\">Returns the value of AxQOS of the transaction.</div></div>",608:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype608\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_qos (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_qos_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxQOS of the transaction.</div></div>",609:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype609\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_id ();</div></div><div class=\"TTSummary\">Returns the value of AxID/RID/BID of the transaction.</div></div>",610:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype610\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_id (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">new_id</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxID/RID/BID of the transaction.</div></div>",611:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype611\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_driver_return_item ();</div></div><div class=\"TTSummary\">Sets the driver_return_item property to XIL_AXI_PAYLOAD_RETURN of the transaction.</div></div>",612:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype612\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_driver_return_item_policy (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_driver_return_policy_t&nbsp;</td><td class=\"PName last\">set</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the driver_return_item property of the transaction. If user want to get the data back from driver, the driver_return_item has to be set to not&nbsp; XIL_AXI_NO_RETURN.</div></div>",613:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype613\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_driver_return_policy_t get_driver_return_item_policy ();</div></div><div class=\"TTSummary\">Returns the value of driver_return_item property of the transaction.</div></div>",614:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype614\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_ulong get_addr ();</div></div><div class=\"TTSummary\">Returns the value of AxADDR of the transaction. AxADDR here can be AWADDR or ARADDR.</div></div>",615:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype615\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_addr (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxADDR of the transaction. AxADDR here can be AWADDR or ARADDR .If user accidently set the address out of range(0, 1&lt;&lt; this.get_addr_width() -1), a warning message will pop up and the address will be truncated to make sure it is in the address range.</div></div>",616:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype616\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_addr_offset();</div></div><div class=\"TTSummary\">Gets address offset of the transaction.</div></div>",617:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype617\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_cmd_id();</div></div><div class=\"TTSummary\">Returns the value of an ID field for the transaction. This can be used for tracking the transaction within the DRIVER or environment.</div></div>",618:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype618\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_cmd_t get_cmd_type();</div></div><div class=\"TTSummary\">Returns the transaction command type (READ/WRITE) of the transaction.</div></div>",619:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype619\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_cmd_type(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cmd_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the transaction command type (READ/WRITE) of the transaction.</div></div>",620:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype620\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_cmd_type_name();</div></div><div class=\"TTSummary\">Returns the string name of the command type of the transaction.</div></div>",621:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype621\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_len_t get_len();</div></div><div class=\"TTSummary\">Returns the value of AxLEN of the transaction. AxLEN can be ARLEN and AWLEN.</div></div>",622:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype622\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_len(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_len_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxLEN of the transaction. AxLEN can be ARLEN and AWLEN, A fatal DRC occurs when any of the following conditions occur: If AXI VIP is configured to be AXI4LITE and the user sets the length other than 0.&nbsp; If AXI VIP is configured to be AXI3 and the user sets the length greater than 16.&nbsp; If the burst type is not INCR and the user sets the length to a value great than 16.&nbsp; If the burst type is fixed and the user sets the length to a value great than 16.&nbsp; If the burst type is WRAP and the user sets the length to a value that is not 2,4,8,16.</div></div>",623:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype623\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_size_t get_size();</div></div><div class=\"TTSummary\">Returns the value of AxSIZE of the transaction. AxSIZE can be ARSIZE and AWSIZE.</div></div>",624:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype624\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_size_name();</div></div><div class=\"TTSummary\">Returns the string name of the value of AxSIZE of the transaction.</div></div>",625:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype625\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_size_t get_dw_size();</div></div><div class=\"TTSummary\">Helper function that will convert the data width value to AxSIZE and return the value;</div></div>",626:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype626\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_size(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_size_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxSIZE of the transaction.</div></div>",627:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype627\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_burst_t get_burst();</div></div><div class=\"TTSummary\">Returns the value of AxBURST of the transaction. AxBURST can be ARBURST and AWBURST.</div></div>",628:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype628\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_burst_name();</div></div><div class=\"TTSummary\">Returns the string name of the value of AxBURST of the transaction.</div></div>",629:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype629\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_burst(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_burst_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxBURST of the transaction. AxBURST can be ARBURST and AWBURST.&nbsp; When AXI VIP HAS_BURST is low, burst type can only be set to INCR, otherwise, FATAL DRC will be file.&nbsp; When AXI VIP HAS_BURST is high and it is AXI4LITE, burst type can only be set to INCR. otherwise, FATAL DRC will be file</div></div>",630:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype630\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_lock_t get_lock();</div></div><div class=\"TTSummary\">Returns the value of AxLOCK of the transaction. AxLOCK can be ARLOCK and AWLOCK.</div></div>",631:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype631\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_lock(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_lock_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxLOCK of the transaction. AxLOCK can be ARLOCK and AWLOCK.</div></div>",632:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype632\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_cache_t get_cache();</div></div><div class=\"TTSummary\">Returns the value of AxCACHE of the transaction. AxCACHE can be ARCACHE and AWCACHE.</div></div>",633:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype633\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_cache(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cache_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxCACHE of the transaction. AxCACHE can be ARCACHE and AWCACHE.</div></div>",634:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype634\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_prot_t get_prot();</div></div><div class=\"TTSummary\">Returns the value of AxPROT of the transaction.AxPROT can be ARPROT and AWPROT.</div></div>",635:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype635\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_prot(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_prot_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of AxPROT of the transaction. AxPROT can be ARPROT and AWPROT.</div></div>",636:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype636\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_trans_state(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_trans_state_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets trans_state of the transaction.</div></div>",637:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype637\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_trans_state_t get_trans_state();</div></div><div class=\"TTSummary\">Returns trans_state of the transaction.</div></div>",638:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype638\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> bit do_compare (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_object&nbsp;</td><td class=\"PName last\">rhs</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Compares two transactions together to make sure that they are identical. It will return 1 when successful.</div></div>",639:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype639\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_user_beat get_awuser();</div></div><div class=\"TTSummary\">Returns the value of the AWUSER.</div></div>",640:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype640\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_awuser(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the AWUSER. Warning will be poped out if user try to set awuser value which is out of range.</div></div>",641:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype641\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_user_beat get_aruser();</div></div><div class=\"TTSummary\">Returns the value of the ARUSER.</div></div>",642:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype642\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_aruser(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the ARUSER. Warning will be poped out if user try to set aruser value which is out of range.</div></div>",643:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype643\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_user_beat get_buser();</div></div><div class=\"TTSummary\">Returns the value of the BUSER.</div></div>",644:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype644\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_buser(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the BUSER of the transaction. Warning will be poped out if user try to set buser value which is out of range.</div></div>",645:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype645\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_beat_index();</div></div><div class=\"TTSummary\">Get current beat index of the beat.</div></div>",646:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype646\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> increment_beat_index();</div></div><div class=\"TTSummary\">Increment beat index of the beat.</div></div>",647:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype647\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_beat_index();</div></div><div class=\"TTSummary\">Clear beat index of the beat.</div></div>",648:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype648\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_addr_delay();</div></div><div class=\"TTSummary\">Returns the value of the address delay from the time command being recevied by write/read driver of master agent to the time the command being put on interface bus. Refer PG267 AXI VIP Agent and Flow Methology about Write Command and Data Flow.</div></div>",649:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype649\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_addr_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the address delay from the time command being recevied by write/read driver of master agent to the time the command being put on interface bus. Refer PG267 AXI VIP Agent and Flow Methology about Write Command and Data Flow.</div></div>",650:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype650\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> adjust_data_insertion_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">now</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Adjust data insertion delay of the transaction. This API is disabled when adjust_data_beat_delay_enabled is low, when it is high, it will be used to adjust the delay between the time when the command is to be processed and the time when the data is applied to the interface.</div></div>",651:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype651\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> adjust_addr_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">now</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Adjust address delay of the transaction. This API is disabled when adjust_addr_delay_enabled is low, when it is high, it will be used to adjust the address delay of the transaction.</div></div>",652:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype652\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> adjust_response_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">now</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Adjust responseess delay of the transaction. This API is disabled when adjust_response_delay_enabled is low, when it is high, it will be used to adjust the response delay.</div></div>",653:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype653\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_data_insertion_delay();</div></div><div class=\"TTSummary\">Returns the transactions insertion delay value. The delay value is the number of clock cycles between transfer being processed to the data transfer being applied to the interface. Refer PG267 AXI VIP Agent and Flow Methology about Write Command and Data Flow.</div></div>",654:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype654\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_data_insertion_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the transactions data insertion delay value, it is number of cycles. This is the delay from the time the transfer is processed to the time the transfer is applied to the interface. Refer PG267 AXI VIP Agent and Flow Methology about Write Command and Data Flow.</div></div>",655:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype655\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_response_delay();</div></div><div class=\"TTSummary\">Returns the number of cycles that the driver will wait before sending the response. Refer PG267 AXI VIP Agent and Flow Methology about Write Response/Reaction and Data Flow.</div></div>",656:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype656\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_response_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the number of cycles that the driver will wait before sending the response.</div></div>",657:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype657\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_allow_data_before_cmd();</div></div><div class=\"TTSummary\">Returns allow_data_before_cmd of the transaction. allow_data_before_cmd is the number of data beat in one transfer which is being written to interface data bus before command is being written.If it is zero, it means that command is being written before data.</div></div>",658:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype658\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_allow_data_before_cmd(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets allow_data_before_cmd of the transaction. allow_data_before_cmd is the number of data beat in one transfer which is being written to interface data bus before command is being written.If it is zero, it means that command is being written before data.&nbsp; The default xfer_wrcmd_order of the transaction is&nbsp; XIL_AXI_WRCMD_ORDER_NONE.&nbsp; When this API is being called, user has to make sure that xfer_wrcmd_order of the transaction has to be set to XIL_AXI_WRCMD_ORDER_DATA_BEFORE_CMD so that this API is doing what user expected. user can user set_xfer_wrcmd_order to set the xfer_wrcmd_order of the transaction.</div></div>",659:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype659\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_xfer_preemptive_probability();</div></div><div class=\"TTSummary\">Gets xfer_preemptive_probability of the transaction.</div></div>",660:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype660\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_xfer_preemptive_probability(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets xfer_preemptive_probability of the transaction.</div></div>",661:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype661\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_resp_t get_bresp();</div></div><div class=\"TTSummary\">Returns the value of BRESP of the transaction.</div></div>",662:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype662\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_bresp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_resp_t&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of BRESP of the transaction.</div></div>",663:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype663\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_bresp_name();</div></div><div class=\"TTSummary\">Gets bresp name of the transaction.</div></div>",664:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype664\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint is_bresp_okay();</div></div><div class=\"TTSummary\">Returns 1 if bresp is XIL_AXI_RESP_OKAY, else returns 0</div></div>",665:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype665\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint is_bresp_slverr();</div></div><div class=\"TTSummary\">Returns 1 if bresp is XIL_AXI_RESP_SLVERR, else returns 0</div></div>",666:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype666\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint is_bresp_decerr();</div></div><div class=\"TTSummary\">Returns 1 if bresp is XIL_AXI_RESP_DECERR, else returns 0</div></div>",667:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype667\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint is_bresp_exokay();</div></div><div class=\"TTSummary\">Returns 1 if bresp is XIL_AXI_RESP_EXOKAY, else returns 0</div></div>",668:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype668\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint all_rresp_okay();</div></div><div class=\"TTSummary\">Returns 1 if rresp is XIL_AXI_RESP_OKAY, else returns 0</div></div>",669:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype669\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint all_rresp_exokay();</div></div><div class=\"TTSummary\">Returns 1 if rresp is XIL_AXI_RESP_EXOKAY, else returns 0</div></div>",670:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype670\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint all_rresp_slverr();</div></div><div class=\"TTSummary\">Returns 1 if rresp is XIL_AXI_RESP_SLVERR, else returns 0</div></div>",671:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype671\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint all_rresp_decerr();</div></div><div class=\"TTSummary\">Returns 1 if rresp is XIL_AXI_RESP_DECERR, else returns 0</div></div>",672:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype672\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_beat_index_delay();</div></div><div class=\"TTSummary\">Returns the current beat delay of the transaction.</div></div>",673:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype673\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_beat_index_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the specified beat delay of the transaction.</div></div>",674:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype674\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_strb_beat_unpacked(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">bit&nbsp;</td><td class=\"PName last\">ret_strb[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the strobe of one beat of the transaction.</div></div>",675:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype675\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_data_beat_unpacked(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_payload_byte&nbsp;</td><td class=\"PName last\">ret_data[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the data of one beat of the transaction.</div></div>",676:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype676\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_data_beat_unpacked(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_payload_byte&nbsp;</td><td class=\"PName last\">ret_data[]</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the data of one beat of the transaction.</div></div>",677:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype677\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_all_resp_okay();</div></div><div class=\"TTSummary\">Sets all_resp_okay of the transaction to be true</div></div>",678:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype678\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_boolean_t get_all_resp_okay();</div></div><div class=\"TTSummary\">Returns all_resp_okay of the transaction.</div></div>",679:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype679\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_all_resp_okay();</div></div><div class=\"TTSummary\">Sets all_resp_okay of the transaction.</div></div>",680:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype680\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_exclude_resp_exokay();</div></div><div class=\"TTSummary\">Sets exclude_resp_exokay of the transaction to be true</div></div>",681:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype681\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_boolean_t get_exclude_resp_exokay();</div></div><div class=\"TTSummary\">Returns exclude_resp_exokay of the transaction.</div></div>",682:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype682\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_exclude_resp_exokay();</div></div><div class=\"TTSummary\">Sets exclude_resp_exokay of the transaction to be false</div></div>",683:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype683\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_xfer_alignment(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_xfer_alignment_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets xfer_alignent of the transaction.</div></div>",684:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype684\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_xfer_alignment_t get_xfer_alignment();</div></div><div class=\"TTSummary\">Returns xfer_alignment of the transaction.</div></div>",685:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype685\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_xfer_wrcmd_order(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_xfer_wrcmd_order_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets xfer_wrcmd_order of the transaction.</div></div>",686:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype686\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_xfer_wrcmd_order_t get_xfer_wrcmd_order();</div></div><div class=\"TTSummary\">Gets xfer_wrcmd_order of the transaction.</div></div>",687:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype687\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_xfer_wrdata_insertion_policy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_xfer_wrdata_insertion_policy_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets xfer_wrdata_insertion_policy of the transaction.</div></div>",688:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype688\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_xfer_wrdata_insertion_policy_t get_xfer_wrdata_insertion_policy();</div></div><div class=\"TTSummary\">Gets xfer_wrdata_insertion_policy of the transaction.</div></div>",689:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype689\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_addr_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_addr_delay and max_addr_delay of the transaction.</div></div>",690:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype690\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_addr_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_addr_delay and max_addr_delay of the transaction. when transaction is randomized,addr_insertion_delay will be inside the range of min_addr_insertion_delay and max_addr_insertion_delay.</div></div>",691:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype691\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_data_insertion_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_data_insertion_delay and max_data_insertion_delay of the transaction.</div></div>",692:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype692\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_response_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_response_delay and max_response_delay of the transaction.</div></div>",693:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype693\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_data_insertion_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_data_insertion_delay and max_data_insertion_delay of the transaction. when transaction is randomized,data_insertion_delay will be inside the range of min_data_insertion_delay and max_data_insertion_delay.</div></div>",694:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype694\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_response_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_response_delay and max_response_delay of the transaction. when transaction is randomized,response_delay will be inside the range of min_response_delay and max_response_delay.</div></div>",695:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype695\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_allow_data_before_cmd_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_allow_data_before_cmd and max_allow_data_before_cmd of the transaction.</div></div>",696:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype696\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_allow_data_before_cmd_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_allow_data_before_cmd and max_allow_data_before_cmd of the transaction. when transaction is randomized, allow_data_before_cmd&nbsp; will be inside the range of min_allow_data_before_cmd and max_allow_data_before_cmd.</div></div>",697:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype697\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_beat_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns min_beat_delay and max_beat_delay of the transaction.</div></div>",698:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype698\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_beat_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets min_beat_delay and max_beat_delay of the transaction. when transaction is randomized,beat_delay will be inside the range of min_beat_delay and max_beat_delay.</div></div>",699:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype699\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_report_errors_number();</div></div><div class=\"TTSummary\">Returns report_errors_number of the transaction.</div></div>",700:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype700\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_report_errors_number(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets report_errors_number of the transaction. report_errors_number is being used to decide maximum number of&nbsp; miscomparsion error messages about data beat,rresp,ruser,wuser will be printed out when API do_compare is being called.</div></div>",701:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype701\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_burst_byte_offset(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns burst byte offset of beat(index) of the transaction.</div></div>",702:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype702\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_transfer_byte_count();</div></div><div class=\"TTSummary\">Returns total number of bytes of one transfer. It equals to transfer.size * (transfer.len+1)</div></div>",703:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype703\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_strb_array();</div></div><div class=\"TTSummary\">Sets all strobe bits of the transaction to 0</div></div>",704:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype704\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_strb_array();</div></div><div class=\"TTSummary\">Sets all strobe bits of the transaction to 1</div></div>",705:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype705\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_data_array();</div></div><div class=\"TTSummary\">Sets data to unknown and strobe to be unknown for write transaction</div></div>",706:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype706\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> size_wr_beats();</div></div><div class=\"TTSummary\">Sets data,strobe and wuser(if WUSER_WIDTH&gt;0),beat_delay of write transaction</div></div>",707:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype707\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> size_rd_beats();</div></div><div class=\"TTSummary\">Sets data,rresp and ruser(if RUSER_WIDTH&gt;0),beat_delay of read transaction</div></div>",708:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype708\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> adjust_head_strb();</div></div><div class=\"TTSummary\">Adjust strobe bit of unaligned head to be 0</div></div>",709:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype709\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> post_randomize();</div></div><div class=\"TTSummary\">Sets final value of region,prot,qos,cache,address,bresp,rresp,strobe of transaction</div></div>",710:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype710\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_beat_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Assign the inter-beat delay of the specified beat.</div></div>",711:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype711\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_uint get_beat_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the inter-beat delay of the specified beat.</div></div>",712:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype712\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_data_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">index,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_data_beat&nbsp;</td><td class=\"PName\">new_data,</td><td></td><td class=\"last\"></td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName\">new_beat_delay</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">0</span>,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_strb_beat&nbsp;</td><td class=\"PName\">new_strb</td><td></td><td class=\"last\"></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Convenience function that will assign the value of the specified beat. it will set the assigned index data and strobe information, default strb is {128{1\'b1}} .</div></div>",713:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype713\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_data_block(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input bit [</td><td class=\"PType\"><span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">4096</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">block</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Convenience function that will assign the data payload for the complete transaction.</div></div>",714:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype714\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_strb_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_strb_beat&nbsp;</td><td class=\"PName last\">new_strb</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Convenience function that will assign the value STRB of the specified beat. default strb is {128{1\'b1}}.</div></div>",715:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype715\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_data_beat get_data_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the value of the specified beat. This is NOT always the RDATA/WDATA representation.&nbsp; It will align the signification bytes to the lower bytes and set the unused bytes to zeros.</div></div>",716:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype716\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit [<span class=\"SHNumber\">8</span>*<span class=\"SHNumber\">4096</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>] get_data_block();</div></div><div class=\"TTSummary\">Returns the 4K bytes of the payload for the transaction. This is NOT always the RDATA/WDATA representation.&nbsp; It will align the signification bytes to the lower bytes and set the unused bytes to zeros.</div></div>",717:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype717\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_strb_beat get_strb_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the value of the specified beat. This is NOT always the WSTRB representation.&nbsp; It will align the signification strobes to the lower bytes and set the unused strobes to zeros.</div></div>",718:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype718\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_user_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets user value of one beat</div></div>",719:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype719\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_ruser(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the RUSER for the beat specified</div></div>",720:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype720\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_wuser(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_user_beat&nbsp;</td><td class=\"PName last\">updated</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the WUSER for the beat specified</div></div>",721:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype721\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_rresp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_resp_t&nbsp;</td><td class=\"PName last\">resp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets the value of the RRESP for the beat specified</div></div>",722:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype722\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_resp_t get_rresp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the value of the RRESP for the beat specified</div></div>",723:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype723\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function string</span> get_rresp_name(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the name of the RRESP for the beat specified</div></div>",724:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype724\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_user_beat get_user_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the value of the xUSER beat at the index provided of the transaction. xUSER here can be WUSER/RUSER.</div></div>",725:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype725\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_user_beat get_wuser(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the value of the WUSER for the beat specified</div></div>",726:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype726\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_user_beat get_ruser(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">index</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns the value of the RUSER for the beat specified</div></div>",727:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype727\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_ulong convert_addr_wrap_to_incr();</div></div><div class=\"TTSummary\">Returns the INCR address of the WRAP transaction. The returned INCR address will be aligned to the AxSIZE of the transaction.</div></div>",728:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype728\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> axi_transaction convert_wrap_to_incr();</div></div><div class=\"TTSummary\">Returns an axi_transaction based on the current transaction, however, converts the WRAP to INCR byte order.&nbsp; This function will change the resultant INCR transaction address to be aligned.</div></div>",729:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype729\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> axi_transaction convert_incr_to_wrap(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input [</td><td class=\"PType\"><span class=\"SHNumber\">10</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">wrap_offset</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns an axi_transaction based on the current transaction, however, converts the INCR to WRAP byte order.&nbsp; This function requires the WRAP offset to correctly return the target word.</div></div>",730:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype730\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> import_data_beat_fields(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span>&nbsp;</td><td class=\"PType\">xil_axi_write_beat&nbsp;</td><td class=\"PName last\">write_beat</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets data,strobe,wuser of write beat</div></div>",731:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype731\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> import_cmd_fields (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span>&nbsp;</td><td class=\"PType\">xil_axi_cmd_beat&nbsp;</td><td class=\"PName last\">cmd</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets addr, cmd, len,size,burst,lock,cache,prot,region,qos,data and beat_delay of cmd beat For write command, set awuser(if AWUSER_WIDTH&gt;0),wuser(if WUSER_WIDTH&gt;0), For read command, set aruser(if ARUSER_WIDTH&gt;0),ruser(if RUSER_WIDTH&gt;0).</div></div>",732:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype732\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> import_rd_beat(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span>&nbsp;</td><td class=\"PType\">xil_axi_read_beat&nbsp;</td><td class=\"PName last\">beat</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets data, ruser(if RUSER_WIDTH&gt;0),rresp of read beat</div></div>",733:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype733\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> auto_fill_transaction(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_data_fill_t&nbsp;</td><td class=\"PName last\">data_pat,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_strb_fill_t&nbsp;</td><td class=\"PName last\">strb_pat,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_data_beat&nbsp;</td><td class=\"PName last\">data_fill</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Fill the transaction with different patterns based on the data_pat/strb_pat selected. When the data_pat is NOT set to XIL_AXI_DATA_FILL_NOTOUCH, The values of the strb\'s will all be set even if the strb_pat is set to XIL_AXI_DATA_FILL_NOTOUCH. refer xil_axi_data_fill_t, xil_axi_strb_fill_t for more information.</div></div>"});