﻿NDSummary.OnToolTipsLoaded("svClass:axi_vif_mem_proxy",{793:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI VIF Proxy object. It has virtual interface for AXI VIP interface.&nbsp; Drivers of AXI VIP drive transaction/ready onto AXI VIP bus interface through APIs(such as&nbsp; put_w/rdata) of this class, monitor of AXI VIP collects AXI interface information and convert it into transaction through APIs(get_w/rdata) in this class.</div></div>",795:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype795\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task wait_aclks(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">cnt</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Waits specified amount of posedge of aclk</div></div>",796:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype796\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_posedge_aclk();</div></div><div class=\"TTSummary\">Waits posedge of ACLK of m_vif</div></div>",797:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype797\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_posedge_aclk_with_hold();</div></div><div class=\"TTSummary\">Waits posedge of ACLK of m_vif occurs,then wait hold_time.</div></div>",798:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype798\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_negedge_aclk();</div></div><div class=\"TTSummary\">Waits negedge of ACLK of m_vif</div></div>",799:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype799\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_areset_deassert();</div></div><div class=\"TTSummary\">Waits areset to be deasserted.</div></div>",800:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype800\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t is_aclk_high();</div></div><div class=\"TTSummary\">Returns TRUE if the aclk is in the HIGH phase of the cycle. It does not look at the ACLKEN to determine if this an active clock.</div></div>",801:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype801\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t is_aclk_low();</div></div><div class=\"TTSummary\">Returns TRUE if the aclk is in the LOW phase of the cycle. It does not look at the ACLKEN to determine if this an active clock.</div></div>",802:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype802\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_boolean_t get_drive_x();</div></div><div class=\"TTSummary\">Returns 1 if dummy_drive_type is XIL_AXI_VIF_DRIVE_X, else returns 0</div></div>",803:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype803\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_axi_vif_dummy_drive_t get_dummy_drive_type(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_cmd_t&nbsp;</td><td class=\"PName last\">d</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Returns dummy_drive_type of m_vif</div></div>",804:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype804\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task put_rdata(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span>&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">transfer,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">beat_num</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Puts specified beat into READ data Channel</div></div>",805:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype805\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task put_wdata(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span>&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">transfer,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">beat_num</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Puts specified beat into Write Data Channel</div></div>",806:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype806\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_axi_vif_mem_proxy&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create a new axi vif proxy and set protocol version</div></div>",807:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype807\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_vif_axi_version_t get_axi_version();</div></div><div class=\"TTSummary\">Returns axi_version of &lt;axi_vif_mem_proxy&gt;.refer xil_axi_vif_axi_version_t for axi_version information.</div></div>",808:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype808\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_axi_version(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_vif_axi_version_t&nbsp;</td><td class=\"PName last\">update</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets axi_version of axi_vif_mem_proxy. refer xil_axi_vif_axi_version_t for axi_version information.</div></div>",809:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype809\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function string</span> get_axi_version_name();</div></div><div class=\"TTSummary\">Returns axi_version\'s name. refer xil_axi_vif_axi_version_t for axi_version information.</div></div>",810:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype810\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_drive_x();</div></div><div class=\"TTSummary\">Sets dummy_drive_type to be XIL_AXI_VIF_DRIVE_X of axi_vif_mem_proxy. Refer xil_axi_vif_dummy_drive_t for dummy drive type.</div></div>",811:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype811\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_dummy_drive_type(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_vif_dummy_drive_t&nbsp;</td><td class=\"PName last\">inp</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets dummy_drive_type of axi_vif_mem_proxy. Refer xil_axi_vif_dummy_drive_t for dummy drive type.</div></div>",812:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype812\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> assign_vi (</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">virtual interface</span> axi_vip_if `</td><td class=\"PType\">AXI_PARAM_ORDER&nbsp;</td><td class=\"PName last\">vif</td></tr></table></td><td class=\"PAfterParameters\">) ;</td></tr></table></div></div><div class=\"TTSummary\">Assigns m_vif of axi_vif_mem_proxy.</div></div>",813:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype813\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">task run_phase();</div></div><div class=\"TTSummary\">Start control processes for operation</div></div>",814:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype814\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_current_clk_count();</div></div><div class=\"TTSummary\">Returns clk_edge_counter of axi_vif_mem_proxy. Increment the clock edge counter on clock negedges, to avoid race conditions with synchronous tasks, that could otherwise execute either before or after thie clock edge counter is incremented.</div></div>",815:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype815\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> time get_current_edge_time();</div></div><div class=\"TTSummary\">Returns clk_edge_time of axi_vif_mem_proxy. clk_edge_time is the time of posedge aclk.</div></div>",816:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype816\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> put_aw_noise();</div></div><div class=\"TTSummary\">Puts noise on Write command channel</div></div>",817:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype817\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> put_ar_noise();</div></div><div class=\"TTSummary\">Puts noise on read command channel</div></div>",818:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype818\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> put_w_noise();</div></div><div class=\"TTSummary\">Puts noise on write data channel</div></div>",819:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype819\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> put_r_noise();</div></div><div class=\"TTSummary\">Puts noise on Read data channel</div></div>",820:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype820\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> put_b_noise();</div></div><div class=\"TTSummary\">Puts noise on Bresp channel</div></div>",821:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype821\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> reset_aw();</div></div><div class=\"TTSummary\">Reset AW channel of &lt;axi_vif_mem_proxy&gt;.clear awvalid and put noise into write command channel.</div></div>",822:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype822\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> reset_ar();</div></div><div class=\"TTSummary\">Resets AR channel of axi_vif_mem_proxy. clear arvalid and put noise into read command channel.</div></div>",823:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype823\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> reset_w();</div></div><div class=\"TTSummary\">Resets W channel of axi_vif_mem_proxy. clear wvalid and put noise into write data channel.</div></div>",824:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype824\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> reset_r();</div></div><div class=\"TTSummary\">Resets R channel of axi_vif_mem_proxy. clear rvalid and put noise into read response channel.</div></div>",825:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype825\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> reset_b();</div></div><div class=\"TTSummary\">Resets B channel of axi_vif_mem_proxy. clear bvalid and put noise into write response channel.</div></div>",826:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype826\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> put_cmd(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span>&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">transfer</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Puts write/read commands on Write/Read commands Channel</div></div>",827:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype827\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> put_bresp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">axi_transaction&nbsp;</td><td class=\"PName last\">transfer</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Puts transaction information onto BRESP channel</div></div>",828:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype828\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_cmd_beat get_awcmd();</div></div><div class=\"TTSummary\">Collects write command channel info from IF and returns it to write command beat</div></div>",829:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype829\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_cmd_beat get_arcmd();</div></div><div class=\"TTSummary\">Collects read command channel info from IF and returns it to read command beat</div></div>",830:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype830\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_resp_beat get_bresp();</div></div><div class=\"TTSummary\">Collects bresp channel info from IF and returns it to bresp beat</div></div>",831:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype831\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_read_beat get_rdata();</div></div><div class=\"TTSummary\">Collects read data channel info from IF and returns it to read data beat</div></div>",832:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype832\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_write_beat get_wdata();</div></div><div class=\"TTSummary\">Collects write data channel info from IF and returns it to write data beat</div></div>",833:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype833\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_awvalid();</div></div><div class=\"TTSummary\">Sets awvalid of m_vif to be 1</div></div>",834:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype834\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_arvalid();</div></div><div class=\"TTSummary\">Sets arvalid of m_vif to be 1</div></div>",835:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype835\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_awvalid();</div></div><div class=\"TTSummary\">Sets awvalid of m_vif to be 0</div></div>",836:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype836\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_arvalid();</div></div><div class=\"TTSummary\">Sets arvalid of m_vif to be 0</div></div>",837:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype837\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_bvalid();</div></div><div class=\"TTSummary\">Sets bvalid of m_vif to be 1</div></div>",838:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype838\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_bvalid();</div></div><div class=\"TTSummary\">Sets bvalid of m_vif to be 0</div></div>",839:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype839\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_rvalid();</div></div><div class=\"TTSummary\">Sets rvalid of m_vif to be 1</div></div>",840:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype840\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_rvalid();</div></div><div class=\"TTSummary\">Sets rvalid of m_vif to be 0</div></div>",841:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype841\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_wvalid();</div></div><div class=\"TTSummary\">Sets wvalid of m_vif to be 1</div></div>",842:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype842\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_wvalid();</div></div><div class=\"TTSummary\">Sets wvalid of m_vif to be 0</div></div>",843:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype843\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_awready();</div></div><div class=\"TTSummary\">Sets awready of m_vif to be 1</div></div>",844:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype844\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_arready();</div></div><div class=\"TTSummary\">Sets arready of m_vif to be 1</div></div>",845:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype845\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_awready();</div></div><div class=\"TTSummary\">Sets awready of m_vif to be 0</div></div>",846:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype846\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_arready();</div></div><div class=\"TTSummary\">Sets arready of m_vif to be 0</div></div>",847:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype847\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_bready();</div></div><div class=\"TTSummary\">Sets bready of m_vif to be 1</div></div>",848:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype848\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_bready();</div></div><div class=\"TTSummary\">Sets bready of m_vif to be 0</div></div>",849:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype849\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_rready();</div></div><div class=\"TTSummary\">Sets rready of m_vif to be 1</div></div>",850:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype850\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_rready();</div></div><div class=\"TTSummary\">Sets rready of m_vif to be 0</div></div>",851:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype851\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> set_wready();</div></div><div class=\"TTSummary\">Sets wready of m_vif to be 1</div></div>",852:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype852\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function void</span> clr_wready();</div></div><div class=\"TTSummary\">Sets wready of m_vif to be 0</div></div>",853:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype853\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_awready_asserted();</div></div><div class=\"TTSummary\">Returns 1 if AWREADY of clock block in m_vif is 1, else returns 0.</div></div>",854:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype854\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_arready_asserted();</div></div><div class=\"TTSummary\">Returns 1 if ARREADY of clock block in m_vif is 1, else returns 0.</div></div>",855:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype855\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_wready_asserted();</div></div><div class=\"TTSummary\">Returns 1 if WREADY of clock block in m_vif is 1, else returns 0.</div></div>",856:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype856\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_rready_asserted();</div></div><div class=\"TTSummary\">Returns 1 if RREADY of clock block in m_vif is 1, else returns 0.</div></div>",857:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype857\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_bready_asserted();</div></div><div class=\"TTSummary\">Returns 1 if BREADY of clock block in m_vif is 1, else returns 0.</div></div>",858:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype858\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_awvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if AWVALID of clock block in m_vif is 1, else returns 0.</div></div>",859:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype859\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_arvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if ARVALID of clock block in m_vif is 1, else returns 0.</div></div>",860:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype860\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_wvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if WVALID of clock block in m_vif is 1, else returns 0.</div></div>",861:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype861\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_rvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if RVALID of clock block in m_vif is 1, else returns 0.</div></div>",862:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype862\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_bvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if BVALID of clock block in m_vif is 1, else returns 0.</div></div>",863:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype863\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_live_awvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if AWVALID of m_vif is 1, else returns 0</div></div>",864:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype864\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_live_arvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if ARVALID of m_vif is 1, else returns 0</div></div>",865:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype865\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_live_wvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if WVALID of m_vif is 1, else returns 0</div></div>",866:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype866\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_live_rvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if RVALID of m_vif is 1, else returns 0</div></div>",867:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype867\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_live_bvalid_asserted();</div></div><div class=\"TTSummary\">Returns 1 if BVALID of m_vif is 1, else returns 0</div></div>",868:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype868\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_live_awvalid_asserted();</div></div><div class=\"TTSummary\">Wait AWVALID of m_vif is 1</div></div>",869:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype869\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_live_arvalid_asserted();</div></div><div class=\"TTSummary\">Wait ARVALID of m_vif is 1</div></div>",870:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype870\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_live_wvalid_asserted();</div></div><div class=\"TTSummary\">Wait WALID of m_vif is 1</div></div>",871:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype871\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_live_rvalid_asserted();</div></div><div class=\"TTSummary\">Wait RVALID of m_vif is 1</div></div>",872:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype872\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_live_bvalid_asserted();</div></div><div class=\"TTSummary\">Wait BVALID of m_vif is 1</div></div>",873:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype873\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_areset_asserted();</div></div><div class=\"TTSummary\">Waits areset to be asserted</div></div>",874:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype874\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_wvalid_sampled();</div></div><div class=\"TTSummary\">Wait till WVALID is sampled</div></div>",875:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype875\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_aw_accepted();</div></div><div class=\"TTSummary\">Waits till AWREADY/AWVALID handshake occurs</div></div>",876:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype876\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_ar_accepted();</div></div><div class=\"TTSummary\">Waits till ARREADY/ARVALID handshake occurs</div></div>",877:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype877\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_r_accepted();</div></div><div class=\"TTSummary\">Waits till RREADY/RVALID handshake occurs</div></div>",878:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype878\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_w_accepted();</div></div><div class=\"TTSummary\">Waits till WREADY/WVALID handshake occurs</div></div>",879:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype879\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual</span> task wait_b_accepted();</div></div><div class=\"TTSummary\">Waits till BREADY/BVALID handshake occurs</div></div>",880:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype880\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_aw_accepted();</div></div><div class=\"TTSummary\">Returns 1 if AWREADY/AWVALID handshake occurs</div></div>",881:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype881\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_ar_accepted();</div></div><div class=\"TTSummary\">Returns 1 if ARREADY/ARVALID handshake occurs</div></div>",882:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype882\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_r_accepted();</div></div><div class=\"TTSummary\">Returns 1 if RREADY/RVALID handshake occurs</div></div>",883:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype883\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_w_accepted();</div></div><div class=\"TTSummary\">Returns 1 if WREADY/WVALID handshake occurs</div></div>",884:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype884\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> bit is_b_accepted();</div></div><div class=\"TTSummary\">Returns 1 if BREADY/BVALID handshake occurs</div></div>"});