﻿NDSummary.OnToolTipsLoaded("svClass:xil_axi_slv_mem_model",{1067:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">AXI Memory Model class. It is an associate array of Systemverilog. The write transaction can write to the memory and the read transaction can read data from the memory. These two features are implemented in the Slave VIP and Passthrough VIP in runtime slave mode. At the same time, the memory model has backdoor APIs for user to access memory directly. Please refer PG267 section about Simple SRAM Memory Model for more details.</div></div>",1069:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1069\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function new</span>(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName\">name</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHString\">&quot;unnamed_xil_axi_slv_mem_model&quot;</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Constructor to create an AXI slave memory model, ~name~ is instance name.</div></div>",1070:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1070\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_bresp_delay_policy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_memory_delay_policy_t&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets BRESP delay policy</div></div>",1071:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1071\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_memory_delay_policy_t get_bresp_delay_policy();</div></div><div class=\"TTSummary\">Returns the current value of the BRESP delay policy</div></div>",1072:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1072\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_inter_beat_gap_delay_policy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_memory_delay_policy_t&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets RDATA delay policy</div></div>",1073:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1073\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_memory_delay_policy_t get_inter_beat_gap_delay_policy();</div></div><div class=\"TTSummary\">Returns the current value of the RDATA delay policy</div></div>",1074:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1074\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_memory_fill_policy(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_memory_fill_policy_t&nbsp;</td><td class=\"PName last\">default_fill_type</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets default memory content fill type</div></div>",1075:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1075\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> xil_axi_memory_fill_policy_t get_memory_fill_policy();</div></div><div class=\"TTSummary\">Gets default memory content fill type</div></div>",1076:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1076\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> set_default_memory_value(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input logic [</td><td class=\"PType\">C_AXI_WDATA_WIDTH-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">value</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets default memory value</div></div>",1077:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1077\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">virtual function</span> logic [C_AXI_WDATA_WIDTH-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>] get_default_memory_value();</div></div><div class=\"TTSummary\">Returns default memory value</div></div>",1078:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1078\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_inter_beat_gap(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets inter beat gap value</div></div>",1079:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1079\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_inter_beat_gap();</div></div><div class=\"TTSummary\">Returns inter beat gap value</div></div>",1080:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1080\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_inter_beat_gap_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets inter beat gap range</div></div>",1081:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1081\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_inter_beat_gap_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Gets inter beat gap range</div></div>",1082:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1082\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_bresp_delay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets BRESP delay value</div></div>",1083:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1083\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> xil_axi_uint get_bresp_delay();</div></div><div class=\"TTSummary\">Returns BRESP delay value</div></div>",1084:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1084\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_bresp_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Sets BRESP delay range</div></div>",1085:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1085\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> get_bresp_delay_range(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">xil_axi_uint&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Gets BRESP delay range</div></div>",1086:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1086\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> backdoor_memory_write(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input logic [</td><td class=\"PType\">C_AXI_WDATA_WIDTH-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">payload,</td></tr><tr><td class=\"PModifierQualifier first\">input logic [</td><td class=\"PType\">C_AXI_WDATA_WIDTH/<span class=\"SHNumber\">8</span>-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">strb</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Back door write data to memory.</div></div>",1087:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1087\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> backdoor_memory_write_4byte(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\">input logic [</td><td class=\"PType\"><span class=\"SHNumber\">31</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">payload,</td></tr><tr><td class=\"PModifierQualifier first\">input logic [</td><td class=\"PType\"><span class=\"SHNumber\">3</span>:<span class=\"SHNumber\">0</span>]&nbsp;</td><td class=\"PName last\">strb</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Back door write data to memory in 4 byte chunks. It will write to the memory with address(addr) with VIP\'s data_width bits wide data(payload) and data_width/8 bits wide strobe(strb). Default strobe is all on {4{1\'b1}}.&nbsp; It will truncate the address if the addr user give is out of range.&nbsp; It will give fatal message if strobe bits is asserted at lower bits than address offset.</div></div>",1088:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1088\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function</span> bit[C_AXI_WDATA_WIDTH-<span class=\"SHNumber\">1</span>:<span class=\"SHNumber\">0</span>] backdoor_memory_read(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Back door read data from memory</div></div>",1089:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1089\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function</span> bit[<span class=\"SHNumber\">31</span>:<span class=\"SHNumber\">0</span>] backdoor_memory_read_4byte(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Back door read data from memory in 4 byte chunks</div></div>",1090:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1090\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function</span> axi_transaction fill_rd_reactive(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Fill in read channel from memory model</div></div>",1091:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1091\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> fill_wr_reactive(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">inout</span>&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Fill in write response channel</div></div>",1092:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1092\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> write_transaction_to_memory(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">axi_transaction&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Write transaction to memory</div></div>",1093:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype1093\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> pre_load_mem(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName last\">data_file,</td></tr><tr><td class=\"PType first\">xil_axi_ulong&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">load binary file into memory with addr offset 1. open the file,fire error if it doesn\'t exist 2. get one byte information by $fgetc file error if the file is empty. else,put byte into tmp_data and start to increment byte_cnt 3. once bytes count reach to memory data width,assign tmp_data to memory address with address offset,reset byte_cnt 4. repeat 2.3 till it reach the EOF of the file</div></div>"});