﻿NDSummary.OnToolTipsLoaded("svClass:xil_sqr_if_base",{464:"<div class=\"NDToolTip TClass Lsv\"><div class=\"TTSummary\">xil_sqr_if_base is a base class which provides the interfaces necessary in order to receive or send sequence items and/or other sequences. xil_sqr_if_base #(T1, T2)</div></div>",466:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype466\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_name(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">string</span>&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Set the name of the xil_sqr_if_base.</div></div>",467:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype467\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function string</span> get_name();</div></div><div class=\"TTSummary\">Return the name of the xil_sqr_if_base .</div></div>",144:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype144\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function void</span> set_max_item_cnt(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input <span class=\"SHKeyword\">integer</span>&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">unsigned</span>&nbsp;</td><td class=\"PName last\">in</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Set the maximum number of concurrent connections to the same inbound/output sequence port.</div></div>",145:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype145\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function integer unsigned</span> get_max_item_cnt();</div></div><div class=\"TTSummary\">Return the maximum number of concurrent connections to the same inbound/output sequence port.</div></div>",146:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype146\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task get_next_item(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">T1&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Pop out sequence item from item queue of xil_sqr_if_base when item queue is not empty. It is a block task and will wait until there is item in the queue.</div></div>",471:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype471\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> try_next_item(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">T1&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Pop out sequence item from item queue of xil_sqr_if_base when item queue is not empty,othewise it returns a null object.It is a non-block task</div></div>",148:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype148\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task wait_for_item_done(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">int</span>&nbsp;</td><td class=\"PName\">transaction_id</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">-1</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">When item_done_cnt of xil_sqr_if_base is not zero, item_done_cnt decrements. it is a block task till there is a done_item_cnt_event occurs.</div></div>",473:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype473\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_uint item_done(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">T1&nbsp;</td><td class=\"PName\">t</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHKeyword\">null</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Give error message about attempting to double pop the item_done queue,and returns 1 while item_inflight_cnt of xil_sqr_if_base is zero.&nbsp; Else it increments item_done_cnt of xil_sqr_if_base and return 0.</div></div>",474:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype474\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_uint put_item(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">T1&nbsp;</td><td class=\"PName\">t</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHKeyword\">null</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Give error message about FIFO is overfilled when item_cnt is bigger than max_item_cnt of xil_sqr_if_base and returns 1. Else it push the item into item queue, increment item_cnt and returns 0.</div></div>",475:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype475\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task get_next_rsp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">T2&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Pop out response item from resonse item queue of xil_sqr_if_base when response queue is not empty. It is a block task until there is response item in the queue.</div></div>",476:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype476\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function void</span> try_next_rsp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">output&nbsp;</td><td class=\"PType\">T2&nbsp;</td><td class=\"PName last\">t</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Pop out response item from item queue of xil_sqr_if_base when response queue is not empty,othewise it returns a null object.It is a non-block task</div></div>",477:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype477\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual</span> task wait_for_rsp_done(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">int</span>&nbsp;</td><td class=\"PName\">transaction_id</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHNumber\">-1</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">When rsp_done_cnt of xil_sqr_if_base is not zero, rsp_done_cnt decrements. it is a block task.</div></div>",478:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype478\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_uint rsp_done(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">T2&nbsp;</td><td class=\"PName\">t</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHKeyword\">null</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Give error message about attempting to double pop the rsp_done queue and returns 1 when rsp_inflight_cnt is zero. Else, it will increment rsp_done_cnt, decrement rsp_inflight_cnt and returns 0.</div></div>",479:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype479\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">virtual function</span> xil_uint put_rsp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input&nbsp;</td><td class=\"PType\">T2&nbsp;</td><td class=\"PName\">t</td><td class=\"PDefaultValueSeparator\">&nbsp;=&nbsp;</td><td class=\"PDefaultValue last\"><span class=\"SHKeyword\">null</span></td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Give error message about response FIFO has overfilled and returns 1 when rsp_cnt is bigger than max_item_cnt. Else, it will put response item into rsp_q of xil_sqr_if_base, increment rsp_cnt and return 0.</div></div>"});