﻿NDSummary.OnToolTipsLoaded("File:axi_vip_if.sv",{37:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype37\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_supports_write();</div></div><div class=\"TTSummary\">Sets supports_write to be 1, when supports_write is being set, ARM protocol Checker will check AW/W channel</div></div>",38:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype38\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_supports_write();</div></div><div class=\"TTSummary\">Sets supports_write to be 0, when supports_write is not being set, ARM protocol Checker will not check AW/W channel</div></div>",39:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype39\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_supports_read();</div></div><div class=\"TTSummary\">Sets supports_read to be 1, when supports_read is being set, ARM protocol Checker will check AR/R channel</div></div>",40:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype40\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_supports_read();</div></div><div class=\"TTSummary\">Sets supports_read to be 0, when supports_read is not being set, ARM protocol Checker will not check AR/R channel</div></div>",41:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype41\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_slave_ready_check();</div></div><div class=\"TTSummary\">Sets xilinx_slave_ready_check_enable to turn on warning message when there is a violation of rules which arready/awready/wready should follow when the VIP goes into reset mode or comes out of reset mode. Which are 1).any READY must be low for the first clock edge that ARESETn goes high--PG101 XILINX_READY_RESET 2).READY must go low after 8 cycles following the first clock edge that ARESETn goes low--UG1037 Xilinx IP generally deasserts all VALID and READY outputs within eight cycles of reset.</div></div>",42:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype42\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_xilinx_slave_ready_check();</div></div><div class=\"TTSummary\">Sets xilinx_slave_ready_check_enable to turn off warning message when there is a violation of rules which arready/awready/wready should follow when the VIP goes into reset mode or comes out of reset mode. Which are 1).any READY must be low for the first clock edge that ARESETn goes high--PG101 XILINX_READY_RESET 2).READY must go low after 8 cycles following the first clock edge that ARESETn goes low--UG1037 Xilinx IP generally deasserts all VALID and READY outputs within eight cycles of reset.</div></div>",43:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype43\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_reset_check();</div></div><div class=\"TTSummary\">Sets xilinx_reset_check_enable to turn on error message when there is a violation of rule which is holding AXI ARESETN asserted for 16 cycles of the slowest AXI clock is generally a sufficient reset pulse width for Xilinx IP--UG1037</div></div>",44:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype44\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_reset_check_to_warn();</div></div><div class=\"TTSummary\">Sets xilinx_reset_check_enable to turn on warning message when there is a violation of rule which is holding AXI ARESETN asserted for 16 cycles of the slowest AXI clock is generally a sufficient reset pulse width for Xilinx IP--UG1037</div></div>",45:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype45\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_xilinx_reset_check();</div></div><div class=\"TTSummary\">Sets xilinx_reset_check_enable to turn off warning/error message when there is a violation of rule which is holding AXI ARESETN asserted for 16 cycles of the slowest AXI clock is generally a sufficient reset pulse width for Xilinx IP--UG1037</div></div>",46:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype46\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_supports_narrow_burst_check();</div></div><div class=\"TTSummary\">Sets xilinx_supports_narrow_burst_check_enable to turn on error message when a narrow burst is being detected while this VIP is in not support narrow burst mode.</div></div>",47:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype47\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_supports_narrow_burst_check_to_warn();</div></div><div class=\"TTSummary\">Sets xilinx_supports_narrow_burst_check_enable to downgrade/upgrade to warning message when a narrow burst is being detected while this VIP is in not support narrow burst mode.</div></div>",48:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype48\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_xilinx_supports_narrow_burst_check();</div></div><div class=\"TTSummary\">Sets xilinx_supports_narrow_burst_check_enable to downgrade error/warning into info message when a narrow burst is being detected while this VIP is in not support narrow burst mode.</div></div>",49:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype49\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_no_strb_address_check();</div></div><div class=\"TTSummary\">Sets xilinx_no_strb_address_check_enable to turn on error message when address is being detected not aligned with data width while this VIP is in no strobe mode.</div></div>",50:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype50\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_no_strb_address_check_to_warn();</div></div><div class=\"TTSummary\">Sets xilinx_no_strb_address_check_enable to downgrade/upgrade to warning message when address is being detected not aligned with data width while this VIP is in no strobe mode.</div></div>",51:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype51\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_xilinx_no_strb_address_check();</div></div><div class=\"TTSummary\">Sets xilinx_no_strb_address_check_enable to downgrade error/warning into info message when address is being detected not aligned with data width while this VIP is in no strobe mode.</div></div>",52:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype52\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_xilinx_supports_narrow_cache_check();</div></div><div class=\"TTSummary\">Sets xilinx_supports_narrow_cache_check_enable to turn on warning message when Cache[1] is not 1 while VIP is in no supports_narrow, has_cache mode.</div></div>",53:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype53\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_xilinx_supports_narrow_cache_check();</div></div><div class=\"TTSummary\">Sets xilinx_supports_narrow_cache_check_enable to downgrade warning into info message when Cache[1] is not 1 while VIP is in no supports_narrow, has_cache mode.</div></div>",54:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype54\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_enable_xchecks();</div></div><div class=\"TTSummary\">Sets enable_xchecks to turn on error message when reset signal is unknown after 1 cycle of clock.</div></div>",55:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype55\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_enable_xchecks_to_warn();</div></div><div class=\"TTSummary\">Sets enable_xchecks to downgrade/upgrade into warning message when reset signal is unknown after 1 cycle of clock.</div></div>",56:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype56\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_enable_xchecks();</div></div><div class=\"TTSummary\">Sets enable_xchecks to downgrade error/warning message into info message when reset signal is unknown after 1 cycle of clock.</div></div>",57:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype57\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_write_response_error_check();</div></div><div class=\"TTSummary\">Sets xilinx_write_response_check_enable to turn on error message when write response is not OKAY.</div></div>",58:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype58\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_write_response_error_check_to_warn();</div></div><div class=\"TTSummary\">Sets xilinx_write_response_check_enable to downgrade/upgrade into warning message when write response is not OKAY.</div></div>",59:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype59\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_write_response_error_check();</div></div><div class=\"TTSummary\">Sets xilinx_write_response_check_enable to downgrade error/warning message into info message when write response is not OKAY.</div></div>",60:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype60\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_read_response_error_check();</div></div><div class=\"TTSummary\">Sets xilinx_read_response_check_enable&nbsp; to turn on error message when read response is not OKAY .</div></div>",61:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype61\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_read_response_error_check_to_warn();</div></div><div class=\"TTSummary\">Sets xilinx_read_response_check_enable to downgrade/upgrade into warning message when read response is not OKAY.</div></div>",62:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype62\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> clr_read_response_error_check();</div></div><div class=\"TTSummary\">Sets xilinx_read_response_check_enable to downgrade error/warning message into info message when read response is not OKAY.</div></div>",63:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype63\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_intf_slave();</div></div><div class=\"TTSummary\">Sets interface to slave mode</div></div>",64:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype64\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_intf_master();</div></div><div class=\"TTSummary\">Sets interface to master mode</div></div>",65:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype65\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function void</span> set_intf_monitor();</div></div><div class=\"TTSummary\">Sets interface to monitor mode</div></div>",66:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype66\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function</span> longint <span class=\"SHKeyword\">unsigned</span> calc_max_latency(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input longint&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">unsigned</span>&nbsp;</td><td class=\"PName last\">start_time,</td></tr><tr><td class=\"first\"></td><td></td><td class=\"PName last\">current_time,</td></tr><tr><td class=\"first\"></td><td></td><td class=\"PName last\">current_max</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Determine if the current max latency is greater than the recently completed transaction.</div></div>",67:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype67\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">function</span> longint <span class=\"SHKeyword\">unsigned</span> calc_running_avg(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\">input longint&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">unsigned</span>&nbsp;</td><td class=\"PName last\">start_time,</td></tr><tr><td class=\"first\"></td><td></td><td class=\"PName last\">current_time,</td></tr><tr><td class=\"first\"></td><td></td><td class=\"PName last\">current_avg</td></tr></table></td><td class=\"PAfterParameters\">);</td></tr></table></div></div><div class=\"TTSummary\">Calculate the running average of the two values.</div></div>",68:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype68\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> longint <span class=\"SHKeyword\">unsigned</span> get_aw_max_latency();</div></div><div class=\"TTSummary\">Return the current WRITE maximum latency value. Measured between the AW handshake to the B handshake.</div></div>",69:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype69\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> longint <span class=\"SHKeyword\">unsigned</span> get_ar_max_latency();</div></div><div class=\"TTSummary\">Return the current READ maximum latency value. Measured between the AR handshake to the R handshake (with RLAST).</div></div>",70:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype70\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> longint <span class=\"SHKeyword\">unsigned</span> get_aw_running_avg_latency();</div></div><div class=\"TTSummary\">Return the current WRITE running average latency value. Measured between the AW handshake to the B handshake.</div></div>",71:"<div class=\"NDToolTip TFunction Lsv\"><div id=\"NDPrototype71\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">function</span> longint <span class=\"SHKeyword\">unsigned</span> get_ar_running_avg_latency();</div></div><div class=\"TTSummary\">Return the current READ running average latency value. Measured between the AR handshake to the R handshake (with RLAST).</div></div>"});